/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.SortItem;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.Predicate;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0.4")
public final class QueryFragmentsAndParameters {
    private static final CypherGenerator cypherGenerator = CypherGenerator.INSTANCE;
    private Map<String, Object> parameters;
    private NodeDescription<?> nodeDescription;
    private final QueryFragments queryFragments;
    private final String cypherQuery;

    public QueryFragmentsAndParameters(NodeDescription<?> nodeDescription, QueryFragments queryFragments, @Nullable Map<String, Object> parameters) {
        this.nodeDescription = nodeDescription;
        this.queryFragments = queryFragments;
        this.parameters = parameters;
        this.cypherQuery = null;
    }

    public QueryFragmentsAndParameters(String cypherQuery) {
        this(cypherQuery, null);
    }

    public QueryFragmentsAndParameters(String cypherQuery, Map<String, Object> parameters) {
        this.cypherQuery = cypherQuery;
        this.queryFragments = new QueryFragments();
        this.parameters = parameters;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public QueryFragments getQueryFragments() {
        return this.queryFragments;
    }

    public String getCypherQuery() {
        return this.cypherQuery;
    }

    public NodeDescription<?> getNodeDescription() {
        return this.nodeDescription;
    }

    public void setParameters(Map<String, Object> newParameters) {
        this.parameters = newParameters;
    }

    public static QueryFragmentsAndParameters forFindById(Neo4jPersistentEntity<?> entityMetaData, Object idValues) {
        Map<String, Object> parameters = Collections.singletonMap("__id__", idValues);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"));
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters);
    }

    public static QueryFragmentsAndParameters forFindByAllId(Neo4jPersistentEntity<?> entityMetaData, Object idValues) {
        Map<String, Object> parameters = Collections.singletonMap("__ids__", idValues);
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)"__ids__"));
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters);
    }

    public static QueryFragmentsAndParameters forFindAll(Neo4jPersistentEntity<?> entityMetaData) {
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(Conditions.noCondition());
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, Collections.emptyMap());
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, null, null);
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example, Sort sort) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, null, sort);
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example, Pageable pageable) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, pageable, null);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1.7")
    public static QueryFragmentsAndParameters forCondition(Neo4jPersistentEntity<?> entityMetaData, Condition condition) {
        return QueryFragmentsAndParameters.forCondition(entityMetaData, condition, null, null);
    }

    static QueryFragmentsAndParameters forCondition(Neo4jPersistentEntity<?> entityMetaData, Condition condition, @Nullable Pageable pageable, @Nullable Collection<SortItem> sortItems) {
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        queryFragments.setRenderConstantsAsParameters(true);
        if (pageable != null) {
            QueryFragmentsAndParameters.adaptPageable(entityMetaData, pageable, queryFragments);
        } else if (sortItems != null) {
            queryFragments.setOrderBy(sortItems);
        }
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, Collections.emptyMap());
    }

    private static void adaptPageable(Neo4jPersistentEntity<?> entityMetaData, Pageable pageable, QueryFragments queryFragments) {
        Sort pageableSort = pageable.getSort();
        queryFragments.setSkip(pageable.getOffset());
        queryFragments.setLimit(pageable.getPageSize());
        queryFragments.setOrderBy(CypherAdapterUtils.toSortItems(entityMetaData, pageableSort));
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example, @Nullable Pageable pageable, @Nullable Sort sort) {
        Predicate predicate = Predicate.create(mappingContext, example);
        Map<String, Object> parameters = predicate.getParameters();
        Condition condition = predicate.getCondition();
        return QueryFragmentsAndParameters.getQueryFragmentsAndParameters((Neo4jPersistentEntity)mappingContext.getPersistentEntity(example.getProbeType()), pageable, sort, parameters, condition);
    }

    public static QueryFragmentsAndParameters forPageableAndSort(Neo4jPersistentEntity<?> neo4jPersistentEntity, @Nullable Pageable pageable, @Nullable Sort sort) {
        return QueryFragmentsAndParameters.getQueryFragmentsAndParameters(neo4jPersistentEntity, pageable, sort, Collections.emptyMap(), null);
    }

    private static QueryFragmentsAndParameters getQueryFragmentsAndParameters(Neo4jPersistentEntity<?> entityMetaData, @Nullable Pageable pageable, @Nullable Sort sort, @Nullable Map<String, Object> parameters, @Nullable Condition condition) {
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        if (pageable != null) {
            QueryFragmentsAndParameters.adaptPageable(entityMetaData, pageable, queryFragments);
        } else if (sort != null) {
            queryFragments.setOrderBy(CypherAdapterUtils.toSortItems(entityMetaData, sort));
        }
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters);
    }
}

