/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.schema.Property;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL)
public abstract class PropertyFilter {
    public static PropertyFilter from(Map<PropertyPath, Boolean> properties, NodeDescription<?> nodeDescription) {
        return new FilteringPropertyFilter(properties, nodeDescription);
    }

    public static PropertyFilter acceptAll() {
        return new NonFilteringPropertyFilter();
    }

    public abstract boolean contains(String var1, Class<?> var2);

    public abstract boolean contains(RelaxedPropertyPath var1);

    public abstract boolean isNotFiltering();

    static String toDotPath(PropertyPath propertyPath, @Nullable String lastSegment) {
        if (lastSegment == null) {
            return propertyPath.toDotPath();
        }
        StringBuilder dotPath = new StringBuilder();
        while (propertyPath != null && propertyPath.hasNext()) {
            dotPath.append(propertyPath.getSegment()).append(".");
            propertyPath = propertyPath.next();
        }
        dotPath.append(lastSegment);
        return dotPath.toString();
    }

    public static class RelaxedPropertyPath {
        private final String dotPath;
        private final Class<?> type;

        public static RelaxedPropertyPath withRootType(Class<?> type) {
            return new RelaxedPropertyPath("", type);
        }

        public String toDotPath() {
            return this.dotPath;
        }

        public String toDotPath(@Nullable String lastSegment) {
            if (lastSegment == null) {
                return this.toDotPath();
            }
            int idx = this.dotPath.lastIndexOf(46);
            if (idx < 0) {
                return lastSegment;
            }
            return this.dotPath.substring(0, idx + 1) + lastSegment;
        }

        public Class<?> getType() {
            return this.type;
        }

        private RelaxedPropertyPath(String dotPath, Class<?> type) {
            this.dotPath = dotPath;
            this.type = type;
        }

        public RelaxedPropertyPath append(String pathPart) {
            return new RelaxedPropertyPath(this.appendToDotPath(pathPart), this.getType());
        }

        public RelaxedPropertyPath prepend(String pathPart) {
            return new RelaxedPropertyPath(this.prependDotPathWith(pathPart), this.getType());
        }

        private String appendToDotPath(String pathPart) {
            return this.dotPath.isEmpty() ? pathPart : this.dotPath + "." + pathPart;
        }

        private String prependDotPathWith(String pathPart) {
            return this.dotPath.isEmpty() ? pathPart : pathPart + "." + this.dotPath;
        }

        public String getSegment() {
            int idx = this.dotPath.indexOf(".");
            if (idx < 0) {
                idx = this.dotPath.length();
            }
            return this.dotPath.substring(0, idx);
        }

        public RelaxedPropertyPath getLeafProperty() {
            int idx = this.dotPath.lastIndexOf(46);
            if (idx < 0) {
                return this;
            }
            return new RelaxedPropertyPath(this.dotPath.substring(idx + 1), this.type);
        }
    }

    private static class NonFilteringPropertyFilter
    extends PropertyFilter {
        private NonFilteringPropertyFilter() {
        }

        @Override
        public boolean contains(String dotPath, Class<?> typeToCheck) {
            return true;
        }

        @Override
        public boolean contains(RelaxedPropertyPath propertyPath) {
            return true;
        }

        @Override
        public boolean isNotFiltering() {
            return true;
        }
    }

    private static class FilteringPropertyFilter
    extends PropertyFilter {
        private final Set<Class<?>> rootClasses;
        private final Map<String, Boolean> projectingPropertyPaths;

        private FilteringPropertyFilter(Map<PropertyPath, Boolean> propertiesMap, NodeDescription<?> nodeDescription) {
            Class<?> domainClass = nodeDescription.getUnderlyingClass();
            this.rootClasses = new HashSet();
            this.rootClasses.add(domainClass);
            Set<PropertyPath> properties = propertiesMap.keySet();
            properties.stream().map(property -> property.getOwningType().getType()).forEach(this.rootClasses::add);
            nodeDescription.getChildNodeDescriptionsInHierarchy().stream().map(NodeDescription::getUnderlyingClass).forEach(this.rootClasses::add);
            Neo4jPersistentEntity entity = (Neo4jPersistentEntity)nodeDescription;
            this.projectingPropertyPaths = new ConcurrentHashMap<String, Boolean>();
            propertiesMap.keySet().forEach(propertyPath -> {
                Neo4jPersistentProperty property;
                String lastSegment = null;
                if (!propertyPath.hasNext() && (property = (Neo4jPersistentProperty)entity.getPersistentProperty(propertyPath.getLeafProperty().getSegment())) != null && property.findAnnotation(Property.class) != null) {
                    lastSegment = property.getPropertyName();
                }
                this.projectingPropertyPaths.put(PropertyFilter.toDotPath(propertyPath, lastSegment), (Boolean)propertiesMap.get(propertyPath));
            });
        }

        @Override
        public boolean contains(String dotPath, Class<?> typeToCheck) {
            if (this.isNotFiltering()) {
                return true;
            }
            if (!this.rootClasses.contains(typeToCheck)) {
                return false;
            }
            Optional<String> first = this.projectingPropertyPaths.keySet().stream().sorted((o1, o2) -> Integer.compare(o2.length(), o1.length())).filter(dotPath::contains).findFirst();
            return this.projectingPropertyPaths.containsKey(dotPath) || first.isPresent() && this.projectingPropertyPaths.get(first.get()) != false;
        }

        @Override
        public boolean contains(RelaxedPropertyPath propertyPath) {
            return this.contains(propertyPath.toDotPath(), propertyPath.getType());
        }

        @Override
        public boolean isNotFiltering() {
            return this.projectingPropertyPaths.isEmpty();
        }
    }
}

