/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.driver.Value;
import org.springframework.data.neo4j.core.mapping.MapValueWrapper;

@API(status=API.Status.INTERNAL, since="6.0")
final class NamedParameters {
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    NamedParameters() {
    }

    void addAll(Map<String, Object> newParameters) {
        newParameters.forEach(this::add);
    }

    void add(String name, Object value) {
        if (this.parameters.containsKey(name)) {
            Object previousValue = this.parameters.get(name);
            throw new IllegalArgumentException(String.format("Duplicate parameter name: '%s' already in the list of named parameters with value '%s'. New value would be '%s'", name, previousValue == null ? "null" : previousValue.toString(), value == null ? "null" : value.toString()));
        }
        if ("__properties__".equals(name) && value != null) {
            this.parameters.put(name, NamedParameters.unwrapMapValueWrapper((Map)value));
        } else {
            this.parameters.put(name, value);
        }
    }

    private static Map<String, Object> unwrapMapValueWrapper(Map<String, Object> properties) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>(properties.size());
        properties.forEach((k, v) -> {
            if (v instanceof MapValueWrapper) {
                Value mapValue = ((MapValueWrapper)v).getMapValue();
                mapValue.keys().forEach(k2 -> newProperties.put((String)k2, mapValue.get(k2)));
            } else {
                newProperties.put((String)k, v);
            }
        });
        return newProperties;
    }

    Map<String, Object> get() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String toString() {
        return this.parameters.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), NamedParameters.formatValue(e.getValue()))).collect(Collectors.joining(", ", ":params {", "}"));
    }

    private static Object formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Cypher.quote((String)((String)value));
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), NamedParameters.formatValue(e.getValue()))).collect(Collectors.joining(", ", "{", "}"));
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(NamedParameters::formatValue).collect(Collectors.joining(", ", "[", "]"));
        }
        return value.toString();
    }
}

