/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.util.TypeInformation;

@API(status=API.Status.INTERNAL, since="6.1.0")
final class Neo4jNestedMapEntityWriter
implements EntityWriter<Object, Map<String, Object>> {
    private final Neo4jMappingContext mappingContext;
    private final Neo4jConversionService conversionService;

    static EntityWriter<Object, Map<String, Object>> forContext(Neo4jMappingContext context) {
        return new Neo4jNestedMapEntityWriter(context);
    }

    private Neo4jNestedMapEntityWriter(Neo4jMappingContext mappingContext) {
        this.mappingContext = mappingContext;
        this.conversionService = mappingContext.getConversionService();
    }

    public void write(Object source, Map<String, Object> sink) {
        if (source == null) {
            return;
        }
        HashSet<Object> seenObjects = new HashSet<Object>();
        this.writeImpl(source, sink, seenObjects);
    }

    Map<String, Object> writeImpl(Object source, Map<String, Object> sink, Set<Object> seenObjects) {
        Class<?> sourceType = source.getClass();
        if (!this.mappingContext.hasPersistentEntityFor(sourceType)) {
            throw new MappingException("Cannot write unknown entity of type '" + sourceType.getName() + "' into a map.");
        }
        Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(sourceType);
        PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(source);
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entity.getIdProperty();
        if (seenObjects.contains(source)) {
            if (idProperty != null) {
                Value idValue = this.mappingContext.getConversionService().writeValue(propertyAccessor.getProperty((PersistentProperty)idProperty), idProperty.getTypeInformation(), null);
                sink.put("__ref__", idValue);
            }
            return sink;
        }
        seenObjects.add(source);
        Neo4jEntityConverter delegate = this.mappingContext.getEntityConverter();
        delegate.write(source, sink);
        this.addLabels(sink, entity, (PersistentPropertyAccessor<Object>)propertyAccessor);
        this.addRelations(sink, entity, (PersistentPropertyAccessor<Object>)propertyAccessor, seenObjects);
        if (idProperty != null && !idProperty.isInternalIdProperty()) {
            Map propertyMap = (Map)sink.get("__properties__");
            propertyMap.remove(idProperty.getPropertyName());
        }
        sink.remove("__version__");
        return sink;
    }

    private Map<String, Object> addRelations(Map<String, Object> sink, Neo4jPersistentEntity<?> entity, PersistentPropertyAccessor<Object> propertyAccessor, Set<Object> seenObjects) {
        Map propertyMap = (Map)sink.get("__properties__");
        entity.doWithAssociations(association -> {
            NestedRelationshipContext context = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, propertyAccessor, entity);
            RelationshipDescription description = (RelationshipDescription)association;
            Neo4jPersistentProperty property = (Neo4jPersistentProperty)association.getInverse();
            Collection unifiedView = Optional.ofNullable(context.getValue()).map(v -> v instanceof Collection ? (List<Object>)v : Collections.singletonList(v)).orElseGet(Collections::emptyList);
            if (property.isDynamicAssociation()) {
                TypeInformation keyType = property.getTypeInformation().getRequiredComponentType();
                Map<String, Value> collect = unifiedView.stream().filter(v -> v != null).flatMap(this.intoSingleMapEntries()).flatMap(this.intoSingleCollectionEntries()).map(relatedEntry -> {
                    String key = this.conversionService.writeValue(relatedEntry.getKey(), keyType, property.getOptionalWritingConverter()).asString();
                    Object relatedObject = relatedEntry.getValue();
                    Map<String, Object> relatedObjectProperties = this.extractPotentialRelationProperties(description, relatedObject, seenObjects);
                    return new AbstractMap.SimpleEntry<String, Map<String, Object>>(key, relatedObjectProperties);
                }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.collectingAndThen(Collectors.toList(), Values::value))));
                if (!collect.isEmpty()) {
                    propertyMap.putAll(collect);
                }
            } else {
                List relatedObjects = unifiedView.stream().filter(v -> v != null).map(relatedObject -> this.extractPotentialRelationProperties(description, relatedObject, seenObjects)).collect(Collectors.toList());
                if (!relatedObjects.isEmpty()) {
                    String type = description.getType();
                    if (propertyMap.containsKey(type)) {
                        Value v2 = (Value)propertyMap.get(type);
                        relatedObjects.addAll(v2.asList(Function.identity()));
                    }
                    propertyMap.put(type, Values.value(relatedObjects));
                }
            }
        });
        return propertyMap;
    }

    private Function<Map.Entry, Stream<? extends Map.Entry>> intoSingleCollectionEntries() {
        return e -> {
            if (e.getValue() instanceof Collection) {
                return ((Collection)e.getValue()).stream().map(v -> new AbstractMap.SimpleEntry(e.getKey(), v));
            }
            return Stream.of(e);
        };
    }

    private Function<Object, Stream<? extends Map.Entry>> intoSingleMapEntries() {
        return e -> {
            if (e instanceof Map) {
                return ((Map)e).entrySet().stream();
            }
            return Stream.of((Map.Entry)e);
        };
    }

    private void addLabels(Map<String, Object> sink, Neo4jPersistentEntity<?> entity, PersistentPropertyAccessor<Object> propertyAccessor) {
        if (!entity.isRelationshipPropertiesEntity()) {
            ArrayList<String> labels = new ArrayList<String>();
            labels.add(entity.getPrimaryLabel());
            entity.getDynamicLabelsProperty().ifPresent(p -> labels.addAll((Collection)propertyAccessor.getProperty((PersistentProperty)p)));
            sink.put("__labels__", Values.value(labels));
        }
    }

    private Map<String, Object> extractPotentialRelationProperties(RelationshipDescription description, Object relatedObject, Set<Object> seenObjects) {
        if (!description.hasRelationshipProperties()) {
            return this.writeImpl(relatedObject, new HashMap<String, Object>(), seenObjects);
        }
        MappingSupport.RelationshipPropertiesWithEntityHolder tuple = (MappingSupport.RelationshipPropertiesWithEntityHolder)relatedObject;
        Map<String, Object> relatedObjectProperties = this.writeImpl(tuple.getRelationshipProperties(), new HashMap<String, Object>(), seenObjects);
        relatedObjectProperties.put("__target__", this.writeImpl(tuple.getRelatedEntity(), new HashMap<String, Object>(), seenObjects));
        return relatedObjectProperties;
    }
}

