/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.DefaultRelationshipDescription;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public enum CypherGenerator {
    INSTANCE;

    private static final SymbolicName START_NODE_NAME;
    private static final SymbolicName END_NODE_NAME;
    private static final SymbolicName RELATIONSHIP_NAME;

    public StatementBuilder.OrderableOngoingReadingAndWith prepareMatchOf(NodeDescription<?> nodeDescription) {
        return this.prepareMatchOf(nodeDescription, null);
    }

    public StatementBuilder.OrderableOngoingReadingAndWith prepareMatchOf(NodeDescription<?> nodeDescription, @Nullable Condition condition) {
        Node rootNode = this.createRootNode(nodeDescription);
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(Constants.NAME_OF_ROOT_NODE);
        expressions.add(Functions.id((Node)rootNode).as("__internalNeo4jId__"));
        return Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(CypherGenerator.conditionOrNoCondition(condition)).with(expressions.toArray(new Expression[0]));
    }

    public StatementBuilder.OngoingReading prepareMatchOf(NodeDescription<?> nodeDescription, @Nullable List<PatternElement> initialMatchOn, @Nullable Condition condition) {
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        Node rootNode = Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_ROOT_NODE);
        StatementBuilder.OngoingReadingWithoutWhere match = null;
        if (initialMatchOn == null || initialMatchOn.isEmpty()) {
            match = Cypher.match((PatternElement[])new PatternElement[]{rootNode});
        } else {
            for (PatternElement patternElement : initialMatchOn) {
                if (match == null) {
                    match = Cypher.match((PatternElement[])new PatternElement[]{patternElement});
                    continue;
                }
                match.match(new PatternElement[]{patternElement});
            }
        }
        ArrayList<AliasedExpression> expressions = new ArrayList<AliasedExpression>();
        expressions.add(Functions.collect((Expression)Functions.id((Node)rootNode)).as("__sn__"));
        return match.where(CypherGenerator.conditionOrNoCondition(condition)).with(expressions.toArray(new Expression[0]));
    }

    public StatementBuilder.OngoingReading prepareMatchOf(NodeDescription<?> nodeDescription, RelationshipDescription relationshipDescription, @Nullable List<PatternElement> initialMatchOn, @Nullable Condition condition) {
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        Node rootNode = Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_ROOT_NODE);
        StatementBuilder.OngoingReadingWithoutWhere match = null;
        if (initialMatchOn == null || initialMatchOn.isEmpty()) {
            match = Cypher.match((PatternElement[])new PatternElement[]{rootNode});
        } else {
            for (PatternElement patternElement : initialMatchOn) {
                if (match == null) {
                    match = Cypher.match((PatternElement[])new PatternElement[]{patternElement});
                    continue;
                }
                match.match(new PatternElement[]{patternElement});
            }
        }
        Node targetNode = Cypher.node((String)relationshipDescription.getTarget().getPrimaryLabel(), relationshipDescription.getTarget().getAdditionalLabels()).named("__srn__");
        boolean dynamicRelationship = relationshipDescription.isDynamic();
        Class componentType = ((Neo4jPersistentProperty)((DefaultRelationshipDescription)relationshipDescription).getInverse()).getComponentType();
        ArrayList<String> relationshipTypes = new ArrayList<String>();
        if (dynamicRelationship && componentType != null && componentType.isEnum()) {
            Arrays.stream(componentType.getEnumConstants()).forEach(constantName -> relationshipTypes.add(constantName.toString()));
        } else if (!dynamicRelationship) {
            relationshipTypes.add(relationshipDescription.getType());
        }
        String[] types = relationshipTypes.toArray(new String[0]);
        Relationship relationship = null;
        switch (relationshipDescription.getDirection()) {
            case OUTGOING: {
                relationship = (Relationship)rootNode.relationshipTo(targetNode, types);
                break;
            }
            case INCOMING: {
                relationship = (Relationship)rootNode.relationshipFrom(targetNode, types);
                break;
            }
            default: {
                relationship = (Relationship)rootNode.relationshipBetween(targetNode, types);
            }
        }
        relationship = relationship.named("__sr__");
        ArrayList<AliasedExpression> expressions = new ArrayList<AliasedExpression>();
        expressions.add(Functions.collect((Expression)Functions.id((Node)rootNode)).as("__sn__"));
        expressions.add(Functions.collect((Expression)Functions.id((Node)targetNode)).as("__srn__"));
        expressions.add(Functions.collect((Expression)Functions.id((Relationship)relationship)).as("__sr__"));
        return match.where(CypherGenerator.conditionOrNoCondition(condition)).optionalMatch(new PatternElement[]{relationship}).with(expressions.toArray(new Expression[0]));
    }

    @NonNull
    public Node createRootNode(NodeDescription<?> nodeDescription) {
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        return Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_ROOT_NODE);
    }

    public Statement createStatementReturningDynamicLabels(NodeDescription<?> nodeDescription) {
        Condition versionCondition;
        Node rootNode = Cypher.anyNode((SymbolicName)Constants.NAME_OF_ROOT_NODE);
        if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
            PersistentProperty versionProperty = ((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty();
            versionCondition = rootNode.property(versionProperty.getName()).isEqualTo((Expression)Cypher.parameter((String)"__version__"));
        } else {
            versionCondition = Conditions.noCondition();
        }
        return ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(nodeDescription.getIdDescription().asIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"))).and(versionCondition)).unwind((Expression)rootNode.labels()).as("label").with(new Expression[]{Cypher.name((String)"label")}).where(Cypher.name((String)"label").in((Expression)Cypher.parameter((String)"__staticLabels__")).not()).returning(new Expression[]{Functions.collect((Expression)Cypher.name((String)"label")).as("__nodeLabels__")}).build();
    }

    public Statement prepareDeleteOf(NodeDescription<?> nodeDescription) {
        return this.prepareDeleteOf(nodeDescription, null);
    }

    public Statement prepareDeleteOf(NodeDescription<?> nodeDescription, @Nullable Condition condition) {
        Node rootNode = Cypher.node((String)nodeDescription.getPrimaryLabel(), nodeDescription.getAdditionalLabels()).named(Constants.NAME_OF_ROOT_NODE);
        return Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(CypherGenerator.conditionOrNoCondition(condition)).detachDelete(new Named[]{rootNode}).build();
    }

    public Statement prepareSaveOf(NodeDescription<?> nodeDescription, UnaryOperator<StatementBuilder.OngoingMatchAndUpdate> updateDecorator) {
        Statement updateIfExists;
        Statement createIfNew;
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        Node rootNode = Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_ROOT_NODE);
        IdDescription idDescription = nodeDescription.getIdDescription();
        Parameter idParameter = Cypher.parameter((String)"__id__");
        if (!idDescription.isInternallyGeneratedId()) {
            String nameOfIdProperty = idDescription.getOptionalGraphPropertyName().orElseThrow(() -> new MappingException("External id does not correspond to a graph property!"));
            if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
                PersistentProperty versionProperty = ((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty();
                String nameOfPossibleExistingNode = "hlp";
                Node possibleExistingNode = Cypher.node((String)primaryLabel, additionalLabels).named(nameOfPossibleExistingNode);
                Statement createIfNew2 = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(possibleExistingNode.property(nameOfIdProperty).isEqualTo((Expression)idParameter)).with(new Named[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode}).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
                Statement updateIfExists2 = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(rootNode.property(nameOfIdProperty).isEqualTo((Expression)idParameter)).and(rootNode.property(versionProperty.getName()).isEqualTo((Expression)Cypher.parameter((String)"__version__")))).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
                return Cypher.union((Statement[])new Statement[]{createIfNew2, updateIfExists2});
            }
            return ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)Cypher.merge((PatternElement[])new PatternElement[]{(PatternElement)rootNode.withProperties(new Object[]{nameOfIdProperty, idParameter})}).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
        }
        String nameOfPossibleExistingNode = "hlp";
        Node possibleExistingNode = Cypher.node((String)primaryLabel, additionalLabels).named(nameOfPossibleExistingNode);
        if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
            PersistentProperty versionProperty = ((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty();
            createIfNew = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(possibleExistingNode.internalId().isEqualTo((Expression)idParameter)).with(new Named[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode}).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
            updateIfExists = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(rootNode.internalId().isEqualTo((Expression)idParameter)).and(rootNode.property(versionProperty.getName()).isEqualTo((Expression)Cypher.parameter((String)"__version__")))).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
        } else {
            createIfNew = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(possibleExistingNode.internalId().isEqualTo((Expression)idParameter)).with(new Named[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode}).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
            updateIfExists = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(rootNode.internalId().isEqualTo((Expression)idParameter)).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
        }
        return Cypher.union((Statement[])new Statement[]{createIfNew, updateIfExists});
    }

    public Statement prepareSaveOfMultipleInstancesOf(NodeDescription<?> nodeDescription) {
        Assert.isTrue((!nodeDescription.isUsingInternalIds() ? 1 : 0) != 0, (String)"Only entities that use external IDs can be saved in a batch.");
        Node rootNode = Cypher.node((String)nodeDescription.getPrimaryLabel(), nodeDescription.getAdditionalLabels()).named(Constants.NAME_OF_ROOT_NODE);
        IdDescription idDescription = nodeDescription.getIdDescription();
        String nameOfIdProperty = idDescription.getOptionalGraphPropertyName().orElseThrow(() -> new MappingException("External id does not correspond to a graph property!"));
        String row = "entity";
        return Cypher.unwind((Expression)Cypher.parameter((String)"__entities__")).as(row).merge(new PatternElement[]{(PatternElement)rootNode.withProperties(new Object[]{nameOfIdProperty, Cypher.property((String)row, (String[])new String[]{"__id__"})})}).mutate((Named)rootNode, (Expression)Cypher.property((String)row, (String[])new String[]{"__properties__"})).returning(new Expression[]{Functions.collect((Expression)rootNode.property(nameOfIdProperty)).as("__ids__")}).build();
    }

    @NonNull
    public Statement prepareSaveOfRelationship(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, @Nullable String dynamicRelationshipType) {
        Node startNode = neo4jPersistentEntity.isUsingInternalIds() ? Cypher.anyNode((SymbolicName)START_NODE_NAME) : Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        String idPropertyName = ((Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredIdProperty()).getPropertyName();
        Parameter idParameter = Cypher.parameter((String)"fromId");
        String type = relationship.isDynamic() ? dynamicRelationshipType : relationship.getType();
        Relationship relationshipFragment = (relationship.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{type}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{type})).named(RELATIONSHIP_NAME);
        return Cypher.match((PatternElement[])new PatternElement[]{startNode}).where(neo4jPersistentEntity.isUsingInternalIds() ? startNode.internalId().isEqualTo((Expression)idParameter) : startNode.property(idPropertyName).isEqualTo((Expression)idParameter)).match(new PatternElement[]{endNode}).where(endNode.internalId().isEqualTo((Expression)Cypher.parameter((String)"toId"))).merge(new PatternElement[]{relationshipFragment}).returning(new Expression[]{Functions.id((Relationship)relationshipFragment)}).build();
    }

    @NonNull
    public Statement prepareSaveOfRelationshipWithProperties(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, boolean isNew, @Nullable String dynamicRelationshipType) {
        Assert.isTrue((boolean)relationship.hasRelationshipProperties(), (String)"Properties required to create a relationship with properties");
        Node startNode = Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        String idPropertyName = ((Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredIdProperty()).getPropertyName();
        Parameter idParameter = Cypher.parameter((String)"fromId");
        Parameter relationshipProperties = Cypher.parameter((String)"__properties__");
        String type = relationship.isDynamic() ? dynamicRelationshipType : relationship.getType();
        Relationship relationshipFragment = (relationship.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{type}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{type})).named(RELATIONSHIP_NAME);
        StatementBuilder.OngoingReadingWithWhere startAndEndNodeMatch = Cypher.match((PatternElement[])new PatternElement[]{startNode}).where(neo4jPersistentEntity.isUsingInternalIds() ? startNode.internalId().isEqualTo((Expression)idParameter) : startNode.property(idPropertyName).isEqualTo((Expression)idParameter)).match(new PatternElement[]{endNode}).where(endNode.internalId().isEqualTo((Expression)Cypher.parameter((String)"toId")));
        StatementBuilder.OngoingUpdate createOrMatch = isNew ? startAndEndNodeMatch.create(new PatternElement[]{relationshipFragment}) : startAndEndNodeMatch.match(new PatternElement[]{relationshipFragment}).where(Functions.id((Relationship)relationshipFragment).isEqualTo((Expression)Cypher.parameter((String)"__knownRelationShipId__")));
        return createOrMatch.mutate((Expression)RELATIONSHIP_NAME, (Expression)relationshipProperties).returning(new Expression[]{Functions.id((Relationship)relationshipFragment)}).build();
    }

    @NonNull
    public Statement prepareDeleteOf(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipDescription) {
        Node startNode = neo4jPersistentEntity.isUsingInternalIds() ? Cypher.anyNode((SymbolicName)START_NODE_NAME) : Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        NodeDescription<?> target = relationshipDescription.getTarget();
        Node endNode = Cypher.node((String)target.getPrimaryLabel(), target.getAdditionalLabels());
        String idPropertyName = ((Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredIdProperty()).getPropertyName();
        boolean outgoing = relationshipDescription.isOutgoing();
        String relationshipType = relationshipDescription.isDynamic() ? null : relationshipDescription.getType();
        String relationshipToRemoveName = "rel";
        Relationship relationship = outgoing ? ((Relationship)startNode.relationshipTo(endNode, new String[]{relationshipType})).named(relationshipToRemoveName) : ((Relationship)startNode.relationshipFrom(endNode, new String[]{relationshipType})).named(relationshipToRemoveName);
        Parameter idParameter = Cypher.parameter((String)"fromId");
        return ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{relationship}).where(neo4jPersistentEntity.isUsingInternalIds() ? startNode.internalId().isEqualTo((Expression)idParameter) : startNode.property(idPropertyName).isEqualTo((Expression)idParameter)).and(Functions.id((Relationship)relationship).in((Expression)Cypher.parameter((String)"__knownRelationShipIds__")).not())).delete(new Expression[]{(Expression)relationship.getSymbolicName().get()}).build();
    }

    public Expression[] createReturnStatementForMatch(NodeDescription<?> nodeDescription) {
        return this.createReturnStatementForMatch(nodeDescription, fieldName -> true);
    }

    @Nullable
    public String createOrderByFragment(@Nullable Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return null;
        }
        Statement statement = Cypher.match((PatternElement[])new PatternElement[]{Cypher.anyNode()}).returning(new String[]{"n"}).orderBy((SortItem[])sort.stream().filter(order -> order != null).map(order -> {
            SymbolicName expression;
            String property = order.getProperty();
            if (property.contains(".")) {
                String[] path = property.split("\\.");
                if (path.length != 2) {
                    throw new IllegalArgumentException(String.format("Cannot handle order property `%s`, it must be a simple property or one-hop path.", property));
                }
                expression = Cypher.property((String)path[0], (String[])new String[]{path[1]});
            } else {
                expression = Cypher.name((String)property);
            }
            return order.isAscending() ? expression.ascending() : expression.descending();
        }).toArray(SortItem[]::new)).build();
        String renderedStatement = Renderer.getDefaultRenderer().render(statement);
        return renderedStatement.substring(renderedStatement.indexOf("ORDER BY")).trim();
    }

    public Expression[] createReturnStatementForMatch(NodeDescription<?> nodeDescription, Predicate<String> includeField) {
        ArrayList<RelationshipDescription> processedRelationships = new ArrayList<RelationshipDescription>();
        if (nodeDescription.containsPossibleCircles(includeField)) {
            return this.createGenericReturnStatement();
        }
        return new Expression[]{this.projectPropertiesAndRelationships(nodeDescription, Constants.NAME_OF_ROOT_NODE, includeField, processedRelationships)};
    }

    public Expression[] createGenericReturnStatement() {
        ArrayList<SymbolicName> returnExpressions = new ArrayList<SymbolicName>();
        returnExpressions.add(Cypher.name((String)"__sn__"));
        returnExpressions.add(Cypher.name((String)"__srn__"));
        returnExpressions.add(Cypher.name((String)"__sr__"));
        return returnExpressions.toArray(new Expression[0]);
    }

    private MapProjection projectAllPropertiesAndRelationships(NodeDescription<?> nodeDescription, SymbolicName nodeName, List<RelationshipDescription> processedRelationships) {
        Predicate<String> includeAllFields = field -> true;
        return this.projectPropertiesAndRelationships(nodeDescription, nodeName, includeAllFields, processedRelationships);
    }

    private MapProjection projectPropertiesAndRelationships(NodeDescription<?> nodeDescription, SymbolicName nodeName, Predicate<String> includedProperties, List<RelationshipDescription> processedRelationships) {
        List<Object> propertiesProjection = this.projectNodeProperties(nodeDescription, nodeName, includedProperties);
        ArrayList<Object> contentOfProjection = new ArrayList<Object>(propertiesProjection);
        Collection<RelationshipDescription> relationships = nodeDescription.getRelationshipsInHierarchy(includedProperties);
        relationships.removeIf(r -> !includedProperties.test(r.getFieldName()));
        contentOfProjection.addAll(this.generateListsFor(relationships, nodeName, processedRelationships));
        return Cypher.anyNode((SymbolicName)nodeName).project(contentOfProjection);
    }

    private List<Object> projectNodeProperties(NodeDescription<?> nodeDescription, SymbolicName nodeName, Predicate<String> includeField) {
        ArrayList<Object> nodePropertiesProjection = new ArrayList<Object>();
        Node node = Cypher.anyNode((SymbolicName)nodeName);
        boolean hasCompositeProperties = false;
        for (GraphPropertyDescription graphProperty : nodeDescription.getGraphPropertiesInHierarchy()) {
            Neo4jPersistentProperty property = (Neo4jPersistentProperty)graphProperty;
            boolean bl = hasCompositeProperties = hasCompositeProperties || property.isComposite();
            if (!includeField.test(property.getFieldName()) || property.isDynamicLabels() || property.isComposite()) continue;
            nodePropertiesProjection.add(graphProperty.getPropertyName());
        }
        if (hasCompositeProperties) {
            nodePropertiesProjection.add("__allProperties__");
            nodePropertiesProjection.add(node.project(new Object[]{Cypher.asterisk()}));
        }
        nodePropertiesProjection.add("__nodeLabels__");
        nodePropertiesProjection.add(Functions.labels((Node)node));
        nodePropertiesProjection.add("__internalNeo4jId__");
        nodePropertiesProjection.add(Functions.id((Node)node));
        return nodePropertiesProjection;
    }

    private List<Object> generateListsFor(Collection<RelationshipDescription> relationships, SymbolicName nodeName, List<RelationshipDescription> processedRelationships) {
        ArrayList<Object> mapProjectionLists = new ArrayList<Object>();
        for (RelationshipDescription relationshipDescription : relationships) {
            String fieldName = relationshipDescription.getFieldName();
            if (!nodeName.equals((Object)Constants.NAME_OF_ROOT_NODE) && relationshipDescription.hasRelationshipObverse() && processedRelationships.contains(relationshipDescription.getRelationshipObverse())) continue;
            this.generateListFor(relationshipDescription, nodeName, processedRelationships, fieldName, mapProjectionLists);
        }
        return mapProjectionLists;
    }

    private void generateListFor(RelationshipDescription relationshipDescription, SymbolicName nodeName, List<RelationshipDescription> processedRelationships, String fieldName, List<Object> mapProjectionLists) {
        String relationshipType = relationshipDescription.getType();
        String relationshipTargetName = relationshipDescription.generateRelatedNodesCollectionName(relationshipDescription.getSource());
        String sourcePrimaryLabel = relationshipDescription.getSource().getMostAbstractParentLabel(relationshipDescription.getSource());
        String targetPrimaryLabel = relationshipDescription.getTarget().getPrimaryLabel();
        List<String> targetAdditionalLabels = relationshipDescription.getTarget().getAdditionalLabels();
        String relationshipSymbolicName = sourcePrimaryLabel + "__relationship__" + targetPrimaryLabel;
        Node startNode = Cypher.anyNode((SymbolicName)nodeName);
        SymbolicName relationshipFieldName = nodeName.concat("_" + fieldName);
        Node endNode = Cypher.node((String)targetPrimaryLabel, targetAdditionalLabels).named(relationshipFieldName);
        NodeDescription<?> endNodeDescription = relationshipDescription.getTarget();
        processedRelationships.add(relationshipDescription);
        if (relationshipDescription.isDynamic()) {
            Relationship relationship = relationshipDescription.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[0]) : (Relationship)startNode.relationshipFrom(endNode, new String[0]);
            relationship = relationship.named(relationshipTargetName);
            MapProjection mapProjection = this.projectAllPropertiesAndRelationships(endNodeDescription, relationshipFieldName, new ArrayList<RelationshipDescription>(processedRelationships));
            if (relationshipDescription.hasRelationshipProperties()) {
                relationship = relationship.named(relationshipSymbolicName);
                mapProjection = mapProjection.and(new Object[]{relationship});
            }
            this.addMapProjection(relationshipTargetName, Cypher.listBasedOn((RelationshipPattern)relationship).returning(new Expression[]{mapProjection.and(new Object[]{"__relationshipType__", Functions.type((Relationship)relationship)})}), mapProjectionLists);
        } else {
            Relationship relationship = relationshipDescription.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{relationshipType}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{relationshipType});
            MapProjection mapProjection = this.projectAllPropertiesAndRelationships(endNodeDescription, relationshipFieldName, new ArrayList<RelationshipDescription>(processedRelationships));
            if (relationshipDescription.hasRelationshipProperties()) {
                relationship = relationship.named(relationshipSymbolicName);
                mapProjection = mapProjection.and(new Object[]{relationship});
            }
            this.addMapProjection(relationshipTargetName, Cypher.listBasedOn((RelationshipPattern)relationship).returning(new Expression[]{mapProjection}), mapProjectionLists);
        }
    }

    private void addMapProjection(String name, Object projection, List<Object> projectionList) {
        projectionList.add(name);
        projectionList.add(projection);
    }

    private static Condition conditionOrNoCondition(@Nullable Condition condition) {
        return condition == null ? Conditions.noCondition() : condition;
    }

    static {
        START_NODE_NAME = Cypher.name((String)"startNode");
        END_NODE_NAME = Cypher.name((String)"endNode");
        RELATIONSHIP_NAME = Cypher.name((String)"relProps");
    }

    private static class RelationshipProcessState {
        private final RelationshipPattern relationship;
        private final boolean done;

        RelationshipProcessState(RelationshipPattern relationship, boolean done) {
            this.relationship = relationship;
            this.done = done;
        }
    }
}

