/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class NestedRelationshipProcessingStateMachine {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();
    private final Set<RelationshipDescription> processedRelationshipDescriptions = new HashSet<RelationshipDescription>();
    private final Set<Object> processedObjects = new HashSet<Object>();

    public NestedRelationshipProcessingStateMachine(Object initialObject) {
        this.processedObjects.add(initialObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessState getStateOf(RelationshipDescription relationshipDescription, @Nullable Collection<?> valuesToStore) {
        try {
            this.read.lock();
            boolean hasProcessedRelationship = this.hasProcessed(relationshipDescription);
            boolean hasProcessedAllValues = this.hasProcessedAllOf(valuesToStore);
            if (hasProcessedRelationship && hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_BOTH;
                return processState;
            }
            if (hasProcessedRelationship) {
                ProcessState processState = ProcessState.PROCESSED_ALL_RELATIONSHIPS;
                return processState;
            }
            if (hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_ALL_VALUES;
                return processState;
            }
            ProcessState processState = ProcessState.PROCESSED_NONE;
            return processState;
        }
        finally {
            this.read.unlock();
        }
    }

    public void markAsProcessed(RelationshipDescription relationshipDescription, @Nullable Collection<?> valuesToStore) {
        try {
            this.write.lock();
            this.processedRelationshipDescriptions.add(relationshipDescription);
            if (valuesToStore != null) {
                valuesToStore.stream().filter(v -> v != null).forEach(this.processedObjects::add);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    private boolean hasProcessedAllOf(@Nullable Collection<?> valuesToStore) {
        if (valuesToStore == null) {
            return false;
        }
        return this.processedObjects.containsAll(valuesToStore);
    }

    private boolean hasProcessed(RelationshipDescription relationshipDescription) {
        if (relationshipDescription != null) {
            return this.processedRelationshipDescriptions.contains(relationshipDescription);
        }
        return false;
    }

    public static enum ProcessState {
        PROCESSED_NONE,
        PROCESSED_BOTH,
        PROCESSED_ALL_RELATIONSHIPS,
        PROCESSED_ALL_VALUES;

    }
}

