/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public enum CypherGenerator {
    INSTANCE;

    private static final SymbolicName START_NODE_NAME;
    private static final SymbolicName END_NODE_NAME;
    private static final SymbolicName RELATIONSHIP_NAME;

    public StatementBuilder.OrderableOngoingReadingAndWith prepareMatchOf(NodeDescription<?> nodeDescription) {
        return this.prepareMatchOf(nodeDescription, null);
    }

    public StatementBuilder.OrderableOngoingReadingAndWith prepareMatchOf(NodeDescription<?> nodeDescription, @Nullable Condition condition) {
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        Node rootNode = Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_ROOT_NODE);
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(Constants.NAME_OF_ROOT_NODE);
        expressions.add(Functions.id((Node)rootNode).as("__internalNeo4jId__"));
        return Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(CypherGenerator.conditionOrNoCondition(condition)).with(expressions.toArray(new Expression[0]));
    }

    public Statement createStatementReturningDynamicLabels(NodeDescription<?> nodeDescription) {
        Condition versionCondition;
        Node rootNode = Cypher.anyNode((SymbolicName)Constants.NAME_OF_ROOT_NODE);
        if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
            PersistentProperty versionProperty = ((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty();
            versionCondition = rootNode.property(versionProperty.getName()).isEqualTo((Expression)Cypher.parameter((String)"__version__"));
        } else {
            versionCondition = Conditions.noCondition();
        }
        return ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(nodeDescription.getIdDescription().asIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"))).and(versionCondition)).unwind((Expression)rootNode.labels()).as("label").with(new Expression[]{Cypher.name((String)"label")}).where(Cypher.name((String)"label").in((Expression)Cypher.parameter((String)"__staticLabels__")).not()).returning(new Expression[]{Functions.collect((Expression)Cypher.name((String)"label")).as("__nodeLabels__")}).build();
    }

    public Statement prepareDeleteOf(NodeDescription<?> nodeDescription) {
        return this.prepareDeleteOf(nodeDescription, null);
    }

    public Statement prepareDeleteOf(NodeDescription<?> nodeDescription, @Nullable Condition condition) {
        Node rootNode = Cypher.node((String)nodeDescription.getPrimaryLabel(), nodeDescription.getAdditionalLabels()).named(Constants.NAME_OF_ROOT_NODE);
        return Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(CypherGenerator.conditionOrNoCondition(condition)).detachDelete(new Named[]{rootNode}).build();
    }

    public Statement prepareSaveOf(NodeDescription<?> nodeDescription, UnaryOperator<StatementBuilder.OngoingMatchAndUpdate> updateDecorator) {
        Statement updateIfExists;
        Statement createIfNew;
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        Node rootNode = Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_ROOT_NODE);
        IdDescription idDescription = nodeDescription.getIdDescription();
        Parameter idParameter = Cypher.parameter((String)"__id__");
        if (!idDescription.isInternallyGeneratedId()) {
            String nameOfIdProperty = idDescription.getOptionalGraphPropertyName().orElseThrow(() -> new MappingException("External id does not correspond to a graph property!"));
            if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
                PersistentProperty versionProperty = ((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty();
                String nameOfPossibleExistingNode = "hlp";
                Node possibleExistingNode = Cypher.node((String)primaryLabel, additionalLabels).named(nameOfPossibleExistingNode);
                Statement createIfNew2 = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply(((StatementBuilder.ExposesSet)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(possibleExistingNode.property(nameOfIdProperty).isEqualTo((Expression)idParameter)).with(new Named[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode})).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
                Statement updateIfExists2 = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply(((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(rootNode.property(nameOfIdProperty).isEqualTo((Expression)idParameter)).and(rootNode.property(versionProperty.getName()).isEqualTo((Expression)Cypher.parameter((String)"__version__")))).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
                return Cypher.union((Statement[])new Statement[]{createIfNew2, updateIfExists2});
            }
            return ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply(((StatementBuilder.ExposesSet)Cypher.merge((PatternElement[])new PatternElement[]{rootNode.withProperties(new Object[]{nameOfIdProperty, idParameter})})).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
        }
        String nameOfPossibleExistingNode = "hlp";
        Node possibleExistingNode = Cypher.node((String)primaryLabel, additionalLabels).named(nameOfPossibleExistingNode);
        if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
            PersistentProperty versionProperty = ((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty();
            createIfNew = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply(((StatementBuilder.ExposesSet)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(possibleExistingNode.internalId().isEqualTo((Expression)idParameter)).with(new Named[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode})).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
            updateIfExists = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply(((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(rootNode.internalId().isEqualTo((Expression)idParameter)).and(rootNode.property(versionProperty.getName()).isEqualTo((Expression)Cypher.parameter((String)"__version__")))).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
        } else {
            createIfNew = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply(((StatementBuilder.ExposesSet)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(possibleExistingNode.internalId().isEqualTo((Expression)idParameter)).with(new Named[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode})).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
            updateIfExists = ((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply(Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(rootNode.internalId().isEqualTo((Expression)idParameter)).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__")))).returning(new Expression[]{rootNode.internalId()}).build();
        }
        return Cypher.union((Statement[])new Statement[]{createIfNew, updateIfExists});
    }

    public Statement prepareSaveOfMultipleInstancesOf(NodeDescription<?> nodeDescription) {
        Assert.isTrue((!nodeDescription.isUsingInternalIds() ? 1 : 0) != 0, (String)"Only entities that use external IDs can be saved in a batch.");
        Node rootNode = Cypher.node((String)nodeDescription.getPrimaryLabel(), nodeDescription.getAdditionalLabels()).named(Constants.NAME_OF_ROOT_NODE);
        IdDescription idDescription = nodeDescription.getIdDescription();
        String nameOfIdProperty = idDescription.getOptionalGraphPropertyName().orElseThrow(() -> new MappingException("External id does not correspond to a graph property!"));
        String row = "entity";
        return ((StatementBuilder.ExposesSet)Cypher.unwind((Expression)Cypher.parameter((String)"__entities__")).as(row).merge(new PatternElement[]{rootNode.withProperties(new Object[]{nameOfIdProperty, Cypher.property((String)row, (String)"__id__")})})).set((Named)rootNode, (Expression)Cypher.property((String)row, (String)"__properties__")).returning(new Expression[]{Functions.collect((Expression)rootNode.property(nameOfIdProperty)).as("__ids__")}).build();
    }

    @NonNull
    public Statement prepareSaveOfRelationship(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, @Nullable String dynamicRelationshipType, Long relatedInternalId) {
        Node startNode = neo4jPersistentEntity.isUsingInternalIds() ? Cypher.anyNode((SymbolicName)START_NODE_NAME) : Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        String idPropertyName = ((Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredIdProperty()).getPropertyName();
        Parameter idParameter = Cypher.parameter((String)"fromId");
        String type = relationship.isDynamic() ? dynamicRelationshipType : relationship.getType();
        return Cypher.match((PatternElement[])new PatternElement[]{startNode}).where(neo4jPersistentEntity.isUsingInternalIds() ? startNode.internalId().isEqualTo((Expression)idParameter) : startNode.property(idPropertyName).isEqualTo((Expression)idParameter)).match(new PatternElement[]{endNode}).where(endNode.internalId().isEqualTo((Expression)Cypher.literalOf((Object)relatedInternalId))).merge(new PatternElement[]{relationship.isOutgoing() ? startNode.relationshipTo(endNode, new String[]{type}) : startNode.relationshipFrom(endNode, new String[]{type})}).build();
    }

    @NonNull
    public Statement prepareSaveOfRelationshipWithProperties(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, @Nullable String dynamicRelationshipType, Long relatedInternalId) {
        Assert.isTrue((boolean)relationship.hasRelationshipProperties(), (String)"Properties required to create a relationship with properties");
        Node startNode = Cypher.anyNode((SymbolicName)START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        String idPropertyName = ((Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredIdProperty()).getPropertyName();
        Parameter idParameter = Cypher.parameter((String)"fromId");
        Parameter relationshipProperties = Cypher.parameter((String)"__properties__");
        String type = relationship.isDynamic() ? dynamicRelationshipType : relationship.getType();
        Relationship relOutgoing = startNode.relationshipTo(endNode, new String[]{type}).named(RELATIONSHIP_NAME);
        Relationship relIncoming = startNode.relationshipFrom(endNode, new String[]{type}).named(RELATIONSHIP_NAME);
        return ((StatementBuilder.BuildableStatement)((StatementBuilder.ExposesSet)Cypher.match((PatternElement[])new PatternElement[]{startNode}).where(neo4jPersistentEntity.isUsingInternalIds() ? startNode.internalId().isEqualTo((Expression)idParameter) : startNode.property(idPropertyName).isEqualTo((Expression)idParameter)).match(new PatternElement[]{endNode}).where(endNode.internalId().isEqualTo((Expression)Cypher.literalOf((Object)relatedInternalId))).merge(new PatternElement[]{relationship.isOutgoing() ? relOutgoing : relIncoming})).set(new Expression[]{RELATIONSHIP_NAME, relationshipProperties})).build();
    }

    @NonNull
    public Statement prepareDeleteOf(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipDescription) {
        Node startNode = neo4jPersistentEntity.isUsingInternalIds() ? Cypher.anyNode((SymbolicName)START_NODE_NAME) : Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        NodeDescription<?> target = relationshipDescription.getTarget();
        Node endNode = Cypher.node((String)target.getPrimaryLabel(), target.getAdditionalLabels());
        String idPropertyName = ((Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredIdProperty()).getPropertyName();
        boolean outgoing = relationshipDescription.isOutgoing();
        String relationshipType = relationshipDescription.isDynamic() ? null : relationshipDescription.getType();
        String relationshipToRemoveName = "rel";
        Relationship relationship = outgoing ? startNode.relationshipTo(endNode, new String[]{relationshipType}).named(relationshipToRemoveName) : startNode.relationshipFrom(endNode, new String[]{relationshipType}).named(relationshipToRemoveName);
        Parameter idParameter = Cypher.parameter((String)"fromId");
        return Cypher.match((PatternElement[])new PatternElement[]{relationship}).where(neo4jPersistentEntity.isUsingInternalIds() ? startNode.internalId().isEqualTo((Expression)idParameter) : startNode.property(idPropertyName).isEqualTo((Expression)idParameter)).delete(new Expression[]{(Expression)relationship.getSymbolicName().get()}).build();
    }

    public Expression createReturnStatementForMatch(NodeDescription<?> nodeDescription) {
        return this.createReturnStatementForMatch(nodeDescription, null);
    }

    @Nullable
    public String createOrderByFragment(@Nullable Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return null;
        }
        Statement statement = Cypher.match((PatternElement[])new PatternElement[]{Cypher.anyNode()}).returning(new String[]{"n"}).orderBy((SortItem[])sort.stream().filter(order -> order != null).map(order -> {
            SymbolicName expression;
            String property = order.getProperty();
            if (property.contains(".")) {
                String[] path = property.split("\\.");
                if (path.length != 2) {
                    throw new IllegalArgumentException(String.format("Cannot handle order property `%s`, it must be a simple property or one-hop path.", property));
                }
                expression = Cypher.property((String)path[0], (String)path[1]);
            } else {
                expression = Cypher.name((String)property);
            }
            return order.isAscending() ? expression.ascending() : expression.descending();
        }).toArray(SortItem[]::new)).build();
        String renderedStatement = Renderer.getDefaultRenderer().render(statement);
        return renderedStatement.substring(renderedStatement.indexOf("ORDER BY")).trim();
    }

    public Expression createReturnStatementForMatch(NodeDescription<?> nodeDescription, @Nullable List<String> inputProperties) {
        Predicate<String> includeField = s -> inputProperties == null || inputProperties.isEmpty() || inputProperties.contains(s);
        SymbolicName nodeName = Constants.NAME_OF_ROOT_NODE;
        ArrayList<RelationshipDescription> processedRelationships = new ArrayList<RelationshipDescription>();
        return this.projectPropertiesAndRelationships(nodeDescription, nodeName, includeField, processedRelationships);
    }

    private MapProjection projectAllPropertiesAndRelationships(NodeDescription<?> nodeDescription, SymbolicName nodeName, List<RelationshipDescription> processedRelationships) {
        Predicate<String> includeAllFields = field -> true;
        return this.projectPropertiesAndRelationships(nodeDescription, nodeName, includeAllFields, processedRelationships);
    }

    private MapProjection projectPropertiesAndRelationships(NodeDescription<?> nodeDescription, SymbolicName nodeName, Predicate<String> includeProperty, List<RelationshipDescription> processedRelationships) {
        List<Object> propertiesProjection = this.projectNodeProperties(nodeDescription, nodeName, includeProperty);
        ArrayList<Object> contentOfProjection = new ArrayList<Object>(propertiesProjection);
        if (nodeDescription.containsPossibleCircles()) {
            Node node = Cypher.anyNode((SymbolicName)nodeName);
            RelationshipPattern pattern = this.createRelationships(node, nodeDescription.getRelationships());
            NamedPath p = Cypher.path((String)"p").definedBy(pattern);
            contentOfProjection.add("__paths__");
            contentOfProjection.add(Cypher.listBasedOn((NamedPath)p).returning(new Named[]{p}));
        } else {
            contentOfProjection.addAll(this.generateListsFor(nodeDescription.getRelationships(), nodeName, includeProperty, processedRelationships));
        }
        return Cypher.anyNode((SymbolicName)nodeName).project(contentOfProjection);
    }

    private RelationshipPattern createRelationships(Node node, Collection<RelationshipDescription> relationshipDescriptions) {
        Relationship.Direction determinedDirection = this.determineDirection(relationshipDescriptions);
        Relationship relationship = Relationship.Direction.OUTGOING.equals((Object)determinedDirection) ? node.relationshipTo(Cypher.anyNode(), this.collectFirstLevelRelationshipTypes(relationshipDescriptions)) : (Relationship.Direction.INCOMING.equals((Object)determinedDirection) ? node.relationshipFrom(Cypher.anyNode(), this.collectFirstLevelRelationshipTypes(relationshipDescriptions)) : node.relationshipBetween(Cypher.anyNode(), this.collectFirstLevelRelationshipTypes(relationshipDescriptions)));
        HashSet<RelationshipDescription> processedRelationshipDescriptions = new HashSet<RelationshipDescription>(relationshipDescriptions);
        for (RelationshipDescription relationshipDescription : relationshipDescriptions) {
            Collection<RelationshipDescription> relationships = relationshipDescription.getTarget().getRelationships();
            if (relationships.size() <= 0) continue;
            relationship = this.createRelationships((RelationshipPattern)relationship, relationships, processedRelationshipDescriptions).relationship;
        }
        return relationship;
    }

    private RelationshipProcessState createRelationships(RelationshipPattern existingRelationship, Collection<RelationshipDescription> relationshipDescriptions, Set<RelationshipDescription> processedRelationshipDescriptions) {
        RelationshipPattern relationship = existingRelationship;
        String[] relationshipTypes = this.collectAllRelationshipTypes(relationshipDescriptions);
        if (processedRelationshipDescriptions.containsAll(relationshipDescriptions)) {
            return new RelationshipProcessState((RelationshipPattern)((RelationshipChain)relationship.relationshipBetween(Cypher.anyNode(), relationshipTypes)).unbounded().min(Integer.valueOf(0)), true);
        }
        processedRelationshipDescriptions.addAll(relationshipDescriptions);
        if (relationshipDescriptions.size() == 1) {
            RelationshipDescription relationshipDescription = relationshipDescriptions.iterator().next();
            switch (relationshipDescription.getDirection()) {
                case OUTGOING: {
                    relationship = ((RelationshipChain)existingRelationship.relationshipTo(Cypher.anyNode(), this.collectFirstLevelRelationshipTypes(relationshipDescriptions))).unbounded().min(Integer.valueOf(0)).max(Integer.valueOf(1));
                    break;
                }
                case INCOMING: {
                    relationship = ((RelationshipChain)existingRelationship.relationshipFrom(Cypher.anyNode(), this.collectFirstLevelRelationshipTypes(relationshipDescriptions))).unbounded().min(Integer.valueOf(0)).max(Integer.valueOf(1));
                    break;
                }
                default: {
                    relationship = ((RelationshipChain)existingRelationship.relationshipBetween(Cypher.anyNode(), this.collectFirstLevelRelationshipTypes(relationshipDescriptions))).unbounded().min(Integer.valueOf(0)).max(Integer.valueOf(1));
                }
            }
            RelationshipProcessState relationships = this.createRelationships(relationship, relationshipDescription.getTarget().getRelationships(), processedRelationshipDescriptions);
            if (!relationships.done) {
                relationship = relationships.relationship;
            }
        } else {
            Relationship.Direction determinedDirection = this.determineDirection(relationshipDescriptions);
            relationship = Relationship.Direction.OUTGOING.equals((Object)determinedDirection) ? ((RelationshipChain)existingRelationship.relationshipTo(Cypher.anyNode(), relationshipTypes)).unbounded().min(Integer.valueOf(0)) : (Relationship.Direction.INCOMING.equals((Object)determinedDirection) ? ((RelationshipChain)existingRelationship.relationshipFrom(Cypher.anyNode(), relationshipTypes)).unbounded().min(Integer.valueOf(0)) : ((RelationshipChain)existingRelationship.relationshipBetween(Cypher.anyNode(), relationshipTypes)).unbounded().min(Integer.valueOf(0)));
            return new RelationshipProcessState(relationship, true);
        }
        return new RelationshipProcessState(relationship, false);
    }

    @Nullable
    Relationship.Direction determineDirection(Collection<RelationshipDescription> relationshipDescriptions) {
        Relationship.Direction direction = null;
        for (RelationshipDescription relationshipDescription : relationshipDescriptions) {
            if (direction == null) {
                direction = relationshipDescription.getDirection();
            }
            if (direction.equals((Object)relationshipDescription.getDirection())) continue;
            return null;
        }
        return direction;
    }

    private String[] collectFirstLevelRelationshipTypes(Collection<RelationshipDescription> relationshipDescriptions) {
        HashSet<String> relationshipTypes = new HashSet<String>();
        for (RelationshipDescription relationshipDescription : relationshipDescriptions) {
            String relationshipType = relationshipDescription.getType();
            if (relationshipTypes.contains(relationshipType)) continue;
            if (relationshipDescription.isDynamic()) {
                relationshipTypes.clear();
                continue;
            }
            relationshipTypes.add(relationshipType);
        }
        return relationshipTypes.toArray(new String[0]);
    }

    private String[] collectAllRelationshipTypes(Collection<RelationshipDescription> relationshipDescriptions) {
        HashSet<String> relationshipTypes = new HashSet<String>();
        for (RelationshipDescription relationshipDescription : relationshipDescriptions) {
            String relationshipType = relationshipDescription.getType();
            if (relationshipDescription.isDynamic()) {
                relationshipTypes.clear();
                continue;
            }
            relationshipTypes.add(relationshipType);
            this.collectAllRelationshipTypes(relationshipDescription.getTarget(), relationshipTypes, new HashSet<RelationshipDescription>(relationshipDescriptions));
        }
        return relationshipTypes.toArray(new String[0]);
    }

    private void collectAllRelationshipTypes(NodeDescription<?> nodeDescription, Set<String> relationshipTypes, Collection<RelationshipDescription> processedRelationshipDescriptions) {
        for (RelationshipDescription relationshipDescription : nodeDescription.getRelationships()) {
            String relationshipType = relationshipDescription.getType();
            if (processedRelationshipDescriptions.contains(relationshipDescription)) continue;
            relationshipTypes.add(relationshipType);
            processedRelationshipDescriptions.add(relationshipDescription);
            this.collectAllRelationshipTypes(relationshipDescription.getTarget(), relationshipTypes, processedRelationshipDescriptions);
        }
    }

    private List<Object> projectNodeProperties(NodeDescription<?> nodeDescription, SymbolicName nodeName, Predicate<String> includeField) {
        ArrayList<Object> nodePropertiesProjection = new ArrayList<Object>();
        Node node = Cypher.anyNode((SymbolicName)nodeName);
        boolean hasCompositeProperties = false;
        for (GraphPropertyDescription graphProperty : nodeDescription.getGraphPropertiesInHierarchy()) {
            Neo4jPersistentProperty property = (Neo4jPersistentProperty)graphProperty;
            boolean bl = hasCompositeProperties = hasCompositeProperties || property.isComposite();
            if (!includeField.test(property.getFieldName()) || property.isDynamicLabels() || property.isComposite()) continue;
            nodePropertiesProjection.add(graphProperty.getPropertyName());
        }
        if (hasCompositeProperties) {
            nodePropertiesProjection.add("__allProperties__");
            nodePropertiesProjection.add(node.project(new Object[]{Cypher.asterisk()}));
        }
        nodePropertiesProjection.add("__nodeLabels__");
        nodePropertiesProjection.add(Functions.labels((Node)node));
        nodePropertiesProjection.add("__internalNeo4jId__");
        nodePropertiesProjection.add(Functions.id((Node)node));
        return nodePropertiesProjection;
    }

    private List<Object> generateListsFor(Collection<RelationshipDescription> relationships, SymbolicName nodeName, Predicate<String> includeField, List<RelationshipDescription> processedRelationships) {
        ArrayList<Object> mapProjectionLists = new ArrayList<Object>();
        for (RelationshipDescription relationshipDescription : relationships) {
            String fieldName = relationshipDescription.getFieldName();
            if (!includeField.test(fieldName) || !nodeName.equals((Object)Constants.NAME_OF_ROOT_NODE) && relationshipDescription.hasRelationshipObverse() && processedRelationships.contains(relationshipDescription.getRelationshipObverse())) continue;
            this.generateListFor(relationshipDescription, nodeName, processedRelationships, fieldName, mapProjectionLists);
        }
        return mapProjectionLists;
    }

    private void generateListFor(RelationshipDescription relationshipDescription, SymbolicName nodeName, List<RelationshipDescription> processedRelationships, String fieldName, List<Object> mapProjectionLists) {
        String relationshipType = relationshipDescription.getType();
        String relationshipTargetName = relationshipDescription.generateRelatedNodesCollectionName();
        String sourcePrimaryLabel = relationshipDescription.getSource().getPrimaryLabel();
        String targetPrimaryLabel = relationshipDescription.getTarget().getPrimaryLabel();
        List<String> targetAdditionalLabels = relationshipDescription.getTarget().getAdditionalLabels();
        String relationshipSymbolicName = sourcePrimaryLabel + "__relationship__" + targetPrimaryLabel;
        Node startNode = Cypher.anyNode((SymbolicName)nodeName);
        SymbolicName relationshipFieldName = nodeName.concat("_" + fieldName);
        Node endNode = Cypher.node((String)targetPrimaryLabel, targetAdditionalLabels).named(relationshipFieldName);
        NodeDescription<?> endNodeDescription = relationshipDescription.getTarget();
        processedRelationships.add(relationshipDescription);
        if (relationshipDescription.isDynamic()) {
            Relationship relationship = relationshipDescription.isOutgoing() ? startNode.relationshipTo(endNode, new String[0]) : startNode.relationshipFrom(endNode, new String[0]);
            relationship = relationship.named(relationshipTargetName);
            MapProjection mapProjection = this.projectAllPropertiesAndRelationships(endNodeDescription, relationshipFieldName, new ArrayList<RelationshipDescription>(processedRelationships));
            if (relationshipDescription.hasRelationshipProperties()) {
                relationship = relationship.named(relationshipSymbolicName);
                mapProjection = mapProjection.and(new Object[]{relationship});
            }
            this.addMapProjection(relationshipTargetName, Cypher.listBasedOn((RelationshipPattern)relationship).returning(new Expression[]{mapProjection.and(new Object[]{"__relationshipType__", Functions.type((Relationship)relationship)})}), mapProjectionLists);
        } else {
            Relationship relationship = relationshipDescription.isOutgoing() ? startNode.relationshipTo(endNode, new String[]{relationshipType}) : startNode.relationshipFrom(endNode, new String[]{relationshipType});
            MapProjection mapProjection = this.projectAllPropertiesAndRelationships(endNodeDescription, relationshipFieldName, new ArrayList<RelationshipDescription>(processedRelationships));
            if (relationshipDescription.hasRelationshipProperties()) {
                relationship = relationship.named(relationshipSymbolicName);
                mapProjection = mapProjection.and(new Object[]{relationship});
            }
            this.addMapProjection(relationshipTargetName, Cypher.listBasedOn((RelationshipPattern)relationship).returning(new Expression[]{mapProjection}), mapProjectionLists);
        }
    }

    private void addMapProjection(String name, Object projection, List<Object> projectionList) {
        projectionList.add(name);
        projectionList.add(projection);
    }

    private static Condition conditionOrNoCondition(@Nullable Condition condition) {
        return condition == null ? Conditions.noCondition() : condition;
    }

    static {
        START_NODE_NAME = Cypher.name((String)"startNode");
        END_NODE_NAME = Cypher.name((String)"endNode");
        RELATIONSHIP_NAME = Cypher.name((String)"relProps");
    }

    private static class RelationshipProcessState {
        private final RelationshipPattern relationship;
        private final boolean done;

        RelationshipProcessState(RelationshipPattern relationship, boolean done) {
            this.relationship = relationship;
            this.done = done;
        }
    }
}

