/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.repository.query.GraphParameterAccessor;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.Assert;

public interface GraphQueryExecution {
    public Object execute(Query var1, Class<?> var2);

    public static final class DeleteByExecution
    implements GraphQueryExecution {
        private final Session session;
        private final GraphQueryMethod graphQueryMethod;

        DeleteByExecution(Session session, GraphQueryMethod graphQueryMethod) {
            this.session = session;
            this.graphQueryMethod = graphQueryMethod;
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            Class returnType = this.graphQueryMethod.getReturnedObjectType();
            if (returnType.equals(Long.class)) {
                return this.session.delete(type, (Iterable)query.getFilters(), this.graphQueryMethod.isCollectionQuery());
            }
            throw new RuntimeException("Long or Iterable<Long> is required as the return type of a Delete query");
        }
    }

    public static final class ExistsByExecution
    implements GraphQueryExecution {
        private final Session session;

        ExistsByExecution(Session session) {
            this.session = session;
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            if (query.isFilterQuery()) {
                return this.session.count(type, (Iterable)query.getFilters()) > 0L;
            }
            Result result = this.session.query(query.getCypherQuery(), query.getParameters());
            return result.iterator().hasNext();
        }
    }

    public static final class CountByExecution
    implements GraphQueryExecution {
        private final Session session;

        CountByExecution(Session session) {
            this.session = session;
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            return this.session.count(type, (Iterable)query.getFilters());
        }
    }

    public static final class SlicedExecution
    implements GraphQueryExecution {
        private final Session session;
        private final GraphParameterAccessor accessor;
        private final Pageable pageable;

        SlicedExecution(Session session, GraphParameterAccessor accessor) {
            this.session = session;
            this.accessor = accessor;
            this.pageable = accessor.getPageable();
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            List result;
            int pageSize = this.pageable.getPageSize();
            if (query.isFilterQuery()) {
                result = (List)this.session.loadAll(type, query.getFilters(), this.accessor.getOgmSort(), query.getPagination(this.pageable, true), this.accessor.getDepth());
            } else {
                String cypherQuery = query.getCypherQuery(this.pageable, true);
                result = type.getAnnotation(QueryResult.class) != null ? (List)this.session.query(cypherQuery, query.getParameters()).queryResults() : (List)this.session.query(type, cypherQuery, query.getParameters());
            }
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }
    }

    public static final class PagedExecution
    implements GraphQueryExecution {
        private final Session session;
        private final Pageable pageable;
        private final GraphParameterAccessor accessor;

        PagedExecution(Session session, GraphParameterAccessor accessor) {
            this.session = session;
            this.pageable = accessor.getPageable();
            this.accessor = accessor;
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            long count;
            List result;
            if (query.isFilterQuery()) {
                result = (List)this.session.loadAll(type, query.getFilters(), this.accessor.getOgmSort(), query.getPagination(this.pageable, false), this.accessor.getDepth());
                count = this.session.count(type, (Iterable)query.getFilters());
            } else {
                result = type.getAnnotation(QueryResult.class) != null ? (List)this.session.query(query.getCypherQuery(this.pageable, false), query.getParameters()).queryResults() : (List)this.session.query(type, query.getCypherQuery(this.pageable, false), query.getParameters());
                count = result.size() > 0 ? (long)this.countTotalNumberOfElements(query).intValue() : 0L;
            }
            return PageableExecutionUtils.getPage((List)result, (Pageable)this.pageable, () -> count);
        }

        private Integer countTotalNumberOfElements(Query query) {
            Assert.hasText((String)query.getCountQuery(), (String)"Must specify a count query to get pagination info.");
            return (Integer)this.session.queryForObject(Integer.class, query.getCountQuery(), query.getParameters());
        }
    }

    public static final class QueryResultExecution
    implements GraphQueryExecution {
        private final Session session;
        private final GraphParameterAccessor accessor;

        QueryResultExecution(Session session, GraphParameterAccessor accessor) {
            this.session = session;
            this.accessor = accessor;
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            return this.session.query(query.getCypherQuery(this.accessor.getSort()), query.getParameters());
        }
    }

    public static final class CollectionExecution
    implements GraphQueryExecution {
        private final Session session;
        private final GraphParameterAccessor accessor;

        CollectionExecution(Session session, GraphParameterAccessor accessor) {
            this.session = session;
            this.accessor = accessor;
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            if (query.isFilterQuery()) {
                return this.session.loadAll(type, query.getFilters(), this.accessor.getOgmSort(), this.accessor.getDepth());
            }
            if (type.getAnnotation(QueryResult.class) != null || Map.class.isAssignableFrom(type)) {
                return this.session.query(query.getCypherQuery(this.accessor.getSort()), query.getParameters()).queryResults();
            }
            return this.session.query(type, query.getCypherQuery(this.accessor.getSort()), query.getParameters());
        }
    }

    public static final class SingleEntityExecution
    implements GraphQueryExecution {
        private final Session session;
        private final GraphParameterAccessor accessor;

        SingleEntityExecution(Session session, GraphParameterAccessor accessor) {
            this.session = session;
            this.accessor = accessor;
        }

        @Override
        public Object execute(Query query, Class<?> type) {
            Iterable result = query.isFilterQuery() ? this.session.loadAll(type, query.getFilters(), this.accessor.getDepth()) : (type.getAnnotation(QueryResult.class) != null ? (Iterable)this.session.query(query.getCypherQuery(), query.getParameters()).queryResults() : this.session.query(type, query.getCypherQuery(), query.getParameters()));
            Iterator iterator = result.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            Object ret = iterator.next();
            if (iterator.hasNext()) {
                throw new IncorrectResultSizeDataAccessException("Incorrect result size: expected at most 1", 1);
            }
            return ret;
        }
    }
}

