/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.mapping.MetaDataProvider;
import org.springframework.data.neo4j.transaction.SessionFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ReflectionUtils;

public class SharedSessionCreator {
    private static final Set<String> TRANSACTION_REQUIRING_METHODS;

    public static Session createSharedSession(SessionFactory sessionFactory) {
        return (Session)Proxy.newProxyInstance(SharedSessionCreator.class.getClassLoader(), new Class[]{Session.class, MetaDataProvider.class}, (InvocationHandler)new SharedSessionInvocationHandler(sessionFactory));
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("deleteAll");
        tmp.add("save");
        tmp.add("delete");
        tmp.add("purgeDatabase");
        TRANSACTION_REQUIRING_METHODS = Collections.unmodifiableSet(tmp);
    }

    private static class SharedSessionInvocationHandler
    implements InvocationHandler {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final SessionFactory sessionFactory;
        private final Method queryMethod;

        public SharedSessionInvocationHandler(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.queryMethod = ReflectionUtils.findMethod(Session.class, (String)"query", (Class[])new Class[]{String.class, Map.class, Boolean.TYPE});
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Function<Session, Object> methodCall;
            String methodName;
            switch (methodName = method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return this.hashCode();
                }
                case "toString": {
                    return "Shared Session proxy for target factory [" + this.sessionFactory + "]";
                }
                case "getMetaData": {
                    return this.sessionFactory.metaData();
                }
                case "beginTransaction": {
                    throw new IllegalStateException("Not allowed to create transaction on shared Session - use Spring transactions instead");
                }
            }
            if (SharedSessionInvocationHandler.isGenericQueryMethod(method)) {
                Object[] newArgs = new Object[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[newArgs.length - 1] = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                methodCall = targetSession -> ReflectionUtils.invokeMethod((Method)this.queryMethod, (Object)targetSession, (Object[])newArgs);
            } else {
                methodCall = targetSession -> ReflectionUtils.invokeMethod((Method)method, (Object)targetSession, (Object[])args);
            }
            return this.invokeInTransaction(methodName, methodCall);
        }

        private static boolean isGenericQueryMethod(Method method) {
            Parameter[] parameters = method.getParameters();
            return "query".equals(method.getName()) && method.getParameterCount() == 2 && parameters[0].getType() == String.class && parameters[1].getType() == Map.class;
        }

        private Object invokeInTransaction(String methodName, Function<Session, Object> methodCall) {
            Session targetSession = SessionFactoryUtils.getSession(this.sessionFactory);
            if (TRANSACTION_REQUIRING_METHODS.contains(methodName) && (targetSession == null || !TransactionSynchronizationManager.isActualTransactionActive() && targetSession.getTransaction() != null && EnumSet.of(Transaction.Status.CLOSED, Transaction.Status.COMMITTED, Transaction.Status.ROLLEDBACK).contains(targetSession.getTransaction().status()))) {
                throw new IllegalStateException("No Session with actual transaction available for current thread - cannot reliably process '" + methodName + "' call");
            }
            if (targetSession == null) {
                this.logger.debug("Creating new Session for shared Session invocation");
                targetSession = this.sessionFactory.openSession();
            }
            return methodCall.apply(targetSession);
        }
    }
}

