/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;

public class GraphParameters
extends Parameters<GraphParameters, GraphParameter> {
    private Integer depthIndex;

    GraphParameters(Method method) {
        super(method);
    }

    GraphParameters(List<GraphParameter> parameters, Integer depthIndex) {
        super(parameters);
        this.depthIndex = depthIndex;
    }

    protected GraphParameter createParameter(MethodParameter parameter) {
        GraphParameter graphParameter = new GraphParameter(parameter);
        if (this.depthIndex == null && graphParameter.isDepthParameter()) {
            this.depthIndex = graphParameter.getIndex();
        } else if (graphParameter.isDepthParameter()) {
            String methodFragment = Optional.ofNullable(parameter).map(MethodParameter::getMethod).map(Method::toString).map(s -> "method " + s).orElse("unknown method");
            throw new IllegalStateException(String.format("Found multiple @Depth annotations on method %s! Only one allowed!", methodFragment));
        }
        return graphParameter;
    }

    protected GraphParameters createFrom(List<GraphParameter> parameters) {
        return new GraphParameters(parameters, this.depthIndex);
    }

    int getDepthIndex() {
        return this.depthIndex != null ? this.depthIndex : -1;
    }

    static class GraphParameter
    extends Parameter {
        private final MethodParameter parameter;

        GraphParameter(MethodParameter parameter) {
            super(parameter);
            this.parameter = parameter;
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || Distance.class.isAssignableFrom(this.getType()) || this.parameter.getParameterAnnotation(Depth.class) != null || Distance.class.isAssignableFrom(this.getType()) || Point.class.isAssignableFrom(this.getType());
        }

        boolean isDepthParameter() {
            return this.parameter.getParameterAnnotation(Depth.class) != null;
        }
    }
}

