/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.DistanceFromNativePoint;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.cypher.function.NativeDistanceComparison;
import org.neo4j.ogm.types.spatial.AbstractPoint;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

class DistanceComparisonBuilder
extends FilterBuilder {
    DistanceComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        Object secondArg;
        Object firstArg = params.pop();
        Filter distanceComparisonFilter = this.needsFilterForSpringPoint(firstArg, secondArg = params.pop()) ? this.springPointFilterOf(firstArg, secondArg) : this.nativePointFilterOf(firstArg, secondArg);
        return Collections.singletonList(distanceComparisonFilter);
    }

    private Filter springPointFilterOf(Object firstArg, Object secondArg) {
        Point point;
        Distance distance;
        if (firstArg instanceof Distance && secondArg instanceof Point) {
            distance = (Distance)firstArg;
            point = (Point)secondArg;
        } else if (secondArg instanceof Distance && firstArg instanceof Point) {
            distance = (Distance)secondArg;
            point = (Point)firstArg;
        } else {
            throw new IllegalArgumentException("findNear requires an argument of type Distance and an argument of type Point");
        }
        return this.createFilterForSpringPoint(point, DistanceComparisonBuilder.calculateDistanceInMeter(distance));
    }

    private Filter nativePointFilterOf(Object firstArg, Object secondArg) {
        AbstractPoint spatialPoint;
        Distance distance;
        if (firstArg instanceof AbstractPoint && secondArg instanceof Distance) {
            distance = (Distance)secondArg;
            spatialPoint = (AbstractPoint)firstArg;
        } else if (firstArg instanceof Distance && secondArg instanceof AbstractPoint) {
            distance = (Distance)firstArg;
            spatialPoint = (AbstractPoint)secondArg;
        } else {
            throw new IllegalArgumentException("findNear requires an argument of type Distance and an argument of type Point");
        }
        return this.createFilterForSpatialPoint(spatialPoint, DistanceComparisonBuilder.calculateDistanceInMeter(distance));
    }

    private boolean needsFilterForSpringPoint(Object firstArg, Object secondArg) {
        return firstArg instanceof Point || secondArg instanceof Point;
    }

    private Filter createFilterForSpatialPoint(AbstractPoint spatialPoint, double meters) {
        NativeDistanceComparison distanceComparison = NativeDistanceComparison.distanceComparisonFor((DistanceFromNativePoint)new DistanceFromNativePoint(spatialPoint, meters));
        String propertyName = this.part.getProperty().getLeafProperty().getSegment();
        Filter filter = new Filter(propertyName, (FilterFunction)distanceComparison, ComparisonOperator.LESS_THAN);
        filter.setOwnerEntityType(this.entityType);
        filter.setBooleanOperator(this.booleanOperator);
        filter.setNegated(this.isNegated());
        this.setNestedAttributes(this.part, filter);
        return filter;
    }

    private Filter createFilterForSpringPoint(Point point, double meters) {
        DistanceFromPoint distanceFromPoint = new DistanceFromPoint(Double.valueOf(point.getX()), Double.valueOf(point.getY()), Double.valueOf(meters));
        DistanceComparison distanceComparison = new DistanceComparison(distanceFromPoint){

            public String expression(String nodeIdentifier) {
                String latitudeProperty = nodeIdentifier + ".latitude";
                String longitudeProperty = nodeIdentifier + ".longitude";
                return String.format("distance(coalesce(point({latitude: %s, longitude: %s}), %s), point({latitude:{lat}, longitude:{lon}})) %s {distance} ", latitudeProperty, longitudeProperty, nodeIdentifier + "." + DistanceComparisonBuilder.this.propertyName(), super.getFilter().getComparisonOperator().getValue());
            }
        };
        Filter filter = new Filter(distanceComparison, ComparisonOperator.LESS_THAN);
        filter.setOwnerEntityType(this.entityType);
        filter.setBooleanOperator(this.booleanOperator);
        filter.setNegated(this.isNegated());
        this.setNestedAttributes(this.part, filter);
        return filter;
    }

    static double calculateDistanceInMeter(Distance distance) {
        if (distance.getMetric() == Metrics.KILOMETERS) {
            return distance.getValue() / 0.001;
        }
        if (distance.getMetric() == Metrics.MILES) {
            return distance.getValue() / 6.2137E-4;
        }
        return distance.getValue();
    }
}

