/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.repository.query.filter.BetweenComparisonBuilder;
import org.springframework.data.neo4j.repository.query.filter.BooleanComparisonBuilder;
import org.springframework.data.neo4j.repository.query.filter.ContainsComparisonBuilder;
import org.springframework.data.neo4j.repository.query.filter.DistanceComparisonBuilder;
import org.springframework.data.neo4j.repository.query.filter.ExistsFilterBuilder;
import org.springframework.data.neo4j.repository.query.filter.IsNullFilterBuilder;
import org.springframework.data.neo4j.repository.query.filter.PropertyComparisonBuilder;
import org.springframework.data.repository.query.parser.Part;

public abstract class FilterBuilder {
    protected Part part;
    protected BooleanOperator booleanOperator;
    protected Class<?> entityType;

    public static FilterBuilder forPartAndEntity(Part part, Class<?> entityType, BooleanOperator booleanOperator) {
        switch (part.getType()) {
            case NEAR: {
                return new DistanceComparisonBuilder(part, booleanOperator, entityType);
            }
            case BETWEEN: {
                return new BetweenComparisonBuilder(part, booleanOperator, entityType);
            }
            case NOT_CONTAINING: 
            case CONTAINING: {
                return FilterBuilder.resolveMatchingContainsFilterBuilder(part, entityType, booleanOperator);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return new IsNullFilterBuilder(part, booleanOperator, entityType);
            }
            case EXISTS: {
                return new ExistsFilterBuilder(part, booleanOperator, entityType);
            }
            case TRUE: 
            case FALSE: {
                return new BooleanComparisonBuilder(part, booleanOperator, entityType);
            }
        }
        return new PropertyComparisonBuilder(part, booleanOperator, entityType);
    }

    FilterBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        this.part = part;
        this.booleanOperator = booleanOperator;
        this.entityType = entityType;
    }

    public abstract List<Filter> build(Stack<Object> var1);

    boolean isNegated() {
        return this.part.getType().name().startsWith("NOT");
    }

    protected String propertyName() {
        return this.part.getProperty().getSegment();
    }

    protected void setNestedAttributes(Part part, Filter filter) {
        ArrayList<Filter.NestedPathSegment> segments = new ArrayList<Filter.NestedPathSegment>();
        PropertyPath property = part.getProperty();
        if (property.hasNext()) {
            filter.setOwnerEntityType(property.getOwningType().getType());
            segments.add(new Filter.NestedPathSegment(property.getSegment(), property.getType()));
            segments.addAll(this.deepNestedProperty(property));
            filter.setPropertyName(property.getLeafProperty().getSegment());
            filter.setNestedPath(segments.toArray(new Filter.NestedPathSegment[0]));
        }
    }

    private List<Filter.NestedPathSegment> deepNestedProperty(PropertyPath path) {
        PropertyPath next;
        ArrayList<Filter.NestedPathSegment> segments = new ArrayList<Filter.NestedPathSegment>();
        if (path.hasNext() && !(next = path.next()).equals((Object)next.getLeafProperty())) {
            segments.add(new Filter.NestedPathSegment(next.getSegment(), next.getType()));
            segments.addAll(this.deepNestedProperty(next));
        }
        return segments;
    }

    private static FilterBuilder resolveMatchingContainsFilterBuilder(Part part, Class<?> entityType, BooleanOperator booleanOperator) {
        boolean usePropertyComparison;
        boolean bl = usePropertyComparison = !part.getProperty().getTypeInformation().isCollectionLike();
        if (usePropertyComparison) {
            return new PropertyComparisonBuilder(part, booleanOperator, entityType);
        }
        return new ContainsComparisonBuilder(part, booleanOperator, entityType);
    }
}

