/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.EmptyStackException;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.repository.query.GraphParameterAccessor;
import org.springframework.data.neo4j.repository.query.GraphQueryExecution;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.repository.query.RepositoryQuery;

public abstract class AbstractGraphRepositoryQuery
implements RepositoryQuery {
    protected final GraphQueryMethod queryMethod;
    protected final MetaData metaData;
    protected final Session session;

    protected AbstractGraphRepositoryQuery(GraphQueryMethod queryMethod, MetaData metaData, Session session) {
        this.queryMethod = queryMethod;
        this.metaData = metaData;
        this.session = session;
    }

    protected abstract Query getQuery(Object[] var1);

    public Object execute(Object[] parameters) {
        Query query;
        try {
            query = this.getQuery(parameters);
        }
        catch (EmptyStackException e) {
            throw new IllegalArgumentException("Not enough arguments for query " + this.getQueryMethod().getName());
        }
        return this.doExecute(query, parameters);
    }

    protected abstract Object doExecute(Query var1, Object[] var2);

    public GraphQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected GraphQueryExecution getExecution(GraphParameterAccessor accessor) {
        if (this.queryMethod.isStreamQuery()) {
            return new GraphQueryExecution.CollectionExecution(this.session, accessor);
        }
        if (this.isCountQuery()) {
            return new GraphQueryExecution.CountByExecution(this.session, accessor);
        }
        if (this.isDeleteQuery()) {
            return new GraphQueryExecution.DeleteByExecution(this.session, this.queryMethod, accessor);
        }
        if (this.returnsOgmSpecificType()) {
            return new GraphQueryExecution.QueryResultExecution(this.session, accessor);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return new GraphQueryExecution.CollectionExecution(this.session, accessor);
        }
        if (this.queryMethod.isPageQuery()) {
            return new GraphQueryExecution.PagedExecution(this.session, accessor);
        }
        if (this.queryMethod.isSliceQuery()) {
            return new GraphQueryExecution.SlicedExecution(this.session, accessor);
        }
        return new GraphQueryExecution.SingleEntityExecution(this.session, accessor);
    }

    private boolean returnsOgmSpecificType() {
        Class<?> returnType = this.queryMethod.getMethod().getReturnType();
        return QueryStatistics.class.isAssignableFrom(returnType) || Result.class.isAssignableFrom(returnType);
    }

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();
}

