/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

class BooleanComparisonBuilder
extends FilterBuilder {
    BooleanComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        Filter filter = new Filter(this.propertyName(), ComparisonOperator.IS_TRUE);
        filter.setOwnerEntityType(this.entityType);
        filter.setBooleanOperator(this.booleanOperator);
        filter.setNegated(this.isNegated() || this.part.getType() == Part.Type.FALSE);
        this.setNestedAttributes(this.part, filter);
        return Collections.singletonList(filter);
    }
}

