/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.util.TypeInformation;

public class Neo4jPersistentEntity<T>
extends BasicPersistentEntity<T, Neo4jPersistentProperty> {
    public Neo4jPersistentEntity(TypeInformation<T> information) {
        super(information);
    }

    protected IsNewStrategy getFallbackIsNewStrategy() {
        return new Neo4jIsNewStrategy(this);
    }

    private static class Neo4jIsNewStrategy
    implements IsNewStrategy {
        private final Neo4jPersistentEntity<?> entity;

        public Neo4jIsNewStrategy(Neo4jPersistentEntity<?> entity) {
            this.entity = entity;
        }

        public boolean isNew(Object bean) {
            PersistentProperty property = this.entity.getRequiredIdProperty();
            Object value = this.entity.getPropertyAccessor(bean).getProperty(property);
            return value == null || value instanceof Long && (Long)value < 0L;
        }
    }
}

