/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.cypher.function.PropertyComparison;
import org.springframework.data.neo4j.repository.query.derived.builder.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

public class BetweenComparisonBuilder
extends FilterBuilder {
    public BetweenComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        Object value1 = params.pop();
        Filter gt = new Filter(this.propertyName(), ComparisonOperator.GREATER_THAN_EQUAL, value1);
        gt.setOwnerEntityType(this.entityType);
        gt.setBooleanOperator(this.booleanOperator);
        gt.setNegated(this.isNegated());
        gt.setFunction((FilterFunction)new PropertyComparison(value1));
        this.setNestedAttributes(this.part, gt);
        Object value2 = params.pop();
        Filter lt = new Filter(this.propertyName(), ComparisonOperator.LESS_THAN_EQUAL, value2);
        lt.setOwnerEntityType(this.entityType);
        lt.setBooleanOperator(BooleanOperator.AND);
        lt.setNegated(this.isNegated());
        lt.setFunction((FilterFunction)new PropertyComparison(value2));
        this.setNestedAttributes(this.part, lt);
        return Arrays.asList(gt, lt);
    }
}

