/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.neo4j.repository.query.AbstractGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.CustomResultConverter;
import org.springframework.data.neo4j.repository.query.GraphParameters;
import org.springframework.data.neo4j.repository.query.GraphParametersParameterAccessor;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;

public class GraphRepositoryQuery
extends AbstractGraphRepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(GraphRepositoryQuery.class);
    private final GraphQueryMethod graphQueryMethod;
    private final Session session;

    public GraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        super(graphQueryMethod, session);
        this.graphQueryMethod = graphQueryMethod;
        this.session = session;
    }

    @Override
    protected Object doExecute(Query query, Object[] parameters) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing query for method {}", (Object)this.graphQueryMethod.getName());
        }
        GraphParametersParameterAccessor accessor = new GraphParametersParameterAccessor(this.graphQueryMethod, parameters);
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        ResultProcessor processor = this.graphQueryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Object result = this.getExecution(accessor).execute(query, processor.getReturnedType().getReturnedType());
        return Result.class.equals(returnType) ? result : processor.processResult(result, (Converter)new CustomResultConverter(this.getMetaData(), processor.getReturnedType().getReturnedType()));
    }

    @Override
    protected Query getQuery(Object[] parameters) {
        return new Query(this.getQueryString(), this.graphQueryMethod.getCountQueryString(), this.resolveParams(parameters));
    }

    Map<String, Object> resolveParams(Object[] parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        GraphParameters methodParameters = this.graphQueryMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = methodParameters.getParameter(i);
            Object parameterValue = this.getParameterValue(parameters[i]);
            params.put(Integer.toString(i), parameterValue);
            if (!parameter.isNamedParameter()) continue;
            parameter.getName().ifPresent(parameterName -> params.put((String)parameterName, parameterValue));
        }
        return params;
    }

    private MetaData getMetaData() {
        return (MetaData)this.session.doInTransaction((requestHandler, transaction, metaData) -> metaData);
    }

    private String getQueryString() {
        return this.getQueryMethod().getQuery();
    }

    private Object getParameterValue(Object parameter) {
        Object parameterValue = this.session.resolveGraphIdFor(parameter);
        if (parameterValue == null) {
            parameterValue = parameter;
        }
        return parameterValue;
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }
}

