/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.builder;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.neo4j.repository.query.derived.builder.CypherFilterBuilder;
import org.springframework.data.repository.query.parser.Part;

public class PropertyComparisonBuilder
extends CypherFilterBuilder {
    public PropertyComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<CypherFilter> build() {
        if (this.part.getProperty().getSegment().contains("visited")) {
            System.out.println("here");
        }
        ArrayList<CypherFilter> filters = new ArrayList<CypherFilter>();
        CypherFilter filter = new CypherFilter();
        filter.setPropertyName(this.propertyName());
        filter.setOwnerEntityType(this.entityType);
        filter.setBooleanOperator(this.booleanOperator);
        filter.setNegated(this.isNegated());
        filter.setComparisonOperator(this.convertToComparisonOperator(this.part.getType()));
        this.setNestedAttributes(this.part, filter);
        filters.add(filter);
        return filters;
    }

    private ComparisonOperator convertToComparisonOperator(Part.Type type) {
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return ComparisonOperator.GREATER_THAN;
            }
            case GREATER_THAN_EQUAL: {
                return ComparisonOperator.GREATER_THAN_EQUAL;
            }
            case BEFORE: 
            case LESS_THAN: {
                return ComparisonOperator.LESS_THAN;
            }
            case LESS_THAN_EQUAL: {
                return ComparisonOperator.LESS_THAN_EQUAL;
            }
            case REGEX: {
                return ComparisonOperator.MATCHES;
            }
            case LIKE: 
            case NOT_LIKE: {
                return ComparisonOperator.LIKE;
            }
            case STARTING_WITH: {
                return ComparisonOperator.STARTING_WITH;
            }
            case ENDING_WITH: {
                return ComparisonOperator.ENDING_WITH;
            }
            case CONTAINING: 
            case NOT_CONTAINING: {
                return ComparisonOperator.CONTAINING;
            }
            case IN: 
            case NOT_IN: {
                return ComparisonOperator.IN;
            }
            case SIMPLE_PROPERTY: {
                return ComparisonOperator.EQUALS;
            }
        }
        throw new IllegalArgumentException("No ComparisonOperator for Part.Type " + type);
    }
}

