/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.session.Session;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryCreator;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class DerivedGraphRepositoryQuery
implements RepositoryQuery {
    private DerivedQueryDefinition queryDefinition;
    private final GraphQueryMethod graphQueryMethod;
    private final PartTree tree;
    protected final Session session;
    protected final EntityMetadata info;
    private final int DEFAULT_QUERY_DEPTH = 1;

    public DerivedGraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        this.graphQueryMethod = graphQueryMethod;
        this.session = session;
        this.info = graphQueryMethod.getEntityInformation();
        this.tree = new PartTree(graphQueryMethod.getName(), this.info.getJavaType());
        this.queryDefinition = (DerivedQueryDefinition)new DerivedQueryCreator(this.tree, this.info.getJavaType()).createQuery();
    }

    public Object execute(Object[] parameters) {
        return this.doExecute(parameters);
    }

    private Object doExecute(Object[] parameters) {
        if (this.tree.isCountProjection().booleanValue()) {
            return new CountByQuery().execute(parameters);
        }
        if (this.tree.isDelete().booleanValue()) {
            return new DeleteByQuery().execute(parameters);
        }
        return new FindByQuery().execute(parameters);
    }

    public QueryMethod getQueryMethod() {
        return this.graphQueryMethod;
    }

    private Filters resolveParams(Object[] parameters) {
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (this.graphQueryMethod.getQueryDepthParamIndex() != null && (this.graphQueryMethod.getQueryDepthParamIndex() == null || this.graphQueryMethod.getQueryDepthParamIndex() == i)) continue;
            params.put(i, parameters[i]);
        }
        List<CypherFilter> cypherFilters = this.queryDefinition.getCypherFilters();
        Filters queryParams = new Filters();
        for (CypherFilter cypherFilter : cypherFilters) {
            cypherFilter.functionAdapter.setValueFromArgs(params);
            queryParams.add(cypherFilter.toFilter());
        }
        return queryParams;
    }

    protected Object createPage(GraphQueryMethod graphQueryMethod, List resultList, Pageable pageable) {
        if (pageable == null) {
            return graphQueryMethod.isPageQuery() ? new PageImpl(resultList) : new SliceImpl(resultList);
        }
        int currentTotal = pageable.getOffset() + resultList.size() + (resultList.size() == pageable.getPageSize() ? pageable.getPageSize() : 0);
        int resultWindowSize = Math.min(resultList.size(), pageable.getPageSize());
        boolean hasNext = resultWindowSize < resultList.size();
        List resultListPage = resultList.subList(0, resultWindowSize);
        return graphQueryMethod.isPageQuery() ? new PageImpl(resultListPage, pageable, (long)currentTotal) : new SliceImpl(resultListPage, pageable, hasNext);
    }

    private SortOrder convert(Sort sort) {
        SortOrder sortOrder = new SortOrder();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    sortOrder.add(new String[]{order.getProperty()});
                    continue;
                }
                sortOrder.add(SortOrder.Direction.DESC, new String[]{order.getProperty()});
            }
        }
        return sortOrder;
    }

    private PagingAndSorting configurePagingAndSorting(Pageable pageable, Sort sort) {
        SortOrder sortOrder = null;
        Pagination pagination = null;
        if (pageable != null) {
            pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize());
            if (pageable.getSort() != null) {
                sortOrder = this.convert(pageable.getSort());
            }
        }
        if (sort != null) {
            sortOrder = this.convert(sort);
        }
        if (this.graphQueryMethod.isPageQuery() || this.graphQueryMethod.isSliceQuery()) {
            if (this.graphQueryMethod.isSliceQuery()) {
                pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize() + 1);
                pagination.setOffset(Integer.valueOf(pageable.getPageNumber() * pageable.getPageSize()));
            } else {
                pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize());
            }
        }
        PagingAndSorting pagingAndSorting = new PagingAndSorting(pagination, sortOrder);
        return pagingAndSorting;
    }

    class PagingAndSorting {
        static final int PAGING_AND_SORTING = 0;
        static final int PAGING_ONLY = 1;
        static final int SORTING_ONLY = 2;
        static final int NO_PAGING_OR_SORTING = 3;
        Pagination pagination;
        SortOrder sortOrder;

        public PagingAndSorting(Pagination pagination, SortOrder sortOrder) {
            this.pagination = pagination;
            this.sortOrder = sortOrder;
        }

        int configuration() {
            if (this.pagination != null && this.sortOrder != null) {
                return 0;
            }
            if (this.pagination != null && this.sortOrder == null) {
                return 1;
            }
            if (this.pagination == null && this.sortOrder != null) {
                return 2;
            }
            return 3;
        }
    }

    class FindByQuery
    implements RepositoryQuery {
        FindByQuery() {
        }

        public Object execute(Object[] parameters) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(DerivedGraphRepositoryQuery.this.graphQueryMethod.getParameters(), parameters);
            Pageable pageable = accessor.getPageable();
            Sort sort = accessor.getSort();
            Class<?> returnType = DerivedGraphRepositoryQuery.this.graphQueryMethod.getMethod().getReturnType();
            Class<?> concreteType = DerivedGraphRepositoryQuery.this.graphQueryMethod.resolveConcreteReturnType();
            int queryDepth = this.calculateQueryDepth(parameters);
            Filters params = DerivedGraphRepositoryQuery.this.resolveParams(parameters);
            if (returnType.equals(Void.class)) {
                throw new RuntimeException("Derived Queries must have a return type");
            }
            if (Iterable.class.isAssignableFrom(returnType)) {
                PagingAndSorting pagingAndSorting = DerivedGraphRepositoryQuery.this.configurePagingAndSorting(pageable, sort);
                List resultList = this.queryResults(concreteType, queryDepth, params, pagingAndSorting);
                if (DerivedGraphRepositoryQuery.this.graphQueryMethod.isPageQuery() || DerivedGraphRepositoryQuery.this.graphQueryMethod.isSliceQuery()) {
                    return DerivedGraphRepositoryQuery.this.createPage(DerivedGraphRepositoryQuery.this.graphQueryMethod, resultList, pageable);
                }
                return resultList;
            }
            Iterator objectIterator = DerivedGraphRepositoryQuery.this.session.loadAll(returnType, params, queryDepth).iterator();
            if (objectIterator.hasNext()) {
                return objectIterator.next();
            }
            return null;
        }

        public QueryMethod getQueryMethod() {
            return DerivedGraphRepositoryQuery.this.graphQueryMethod;
        }

        private List queryResults(Class<?> concreteType, int queryDepth, Filters params, PagingAndSorting pagingAndSorting) {
            List resultList;
            switch (pagingAndSorting.configuration()) {
                case 0: {
                    resultList = (List)DerivedGraphRepositoryQuery.this.session.loadAll(concreteType, params, pagingAndSorting.sortOrder, pagingAndSorting.pagination, queryDepth);
                    break;
                }
                case 1: {
                    resultList = (List)DerivedGraphRepositoryQuery.this.session.loadAll(concreteType, params, pagingAndSorting.pagination, queryDepth);
                    break;
                }
                case 2: {
                    resultList = (List)DerivedGraphRepositoryQuery.this.session.loadAll(concreteType, params, pagingAndSorting.sortOrder, queryDepth);
                    break;
                }
                case 3: {
                    resultList = (List)DerivedGraphRepositoryQuery.this.session.loadAll(concreteType, params, queryDepth);
                    break;
                }
                default: {
                    resultList = (List)DerivedGraphRepositoryQuery.this.session.loadAll(concreteType, params, queryDepth);
                }
            }
            return resultList;
        }

        private int calculateQueryDepth(Object[] parameters) {
            int queryDepth = 1;
            if (DerivedGraphRepositoryQuery.this.graphQueryMethod.hasStaticDepth()) {
                queryDepth = DerivedGraphRepositoryQuery.this.graphQueryMethod.getQueryDepth();
            } else if (DerivedGraphRepositoryQuery.this.graphQueryMethod.getQueryDepthParamIndex() != null) {
                queryDepth = (Integer)parameters[DerivedGraphRepositoryQuery.this.graphQueryMethod.getQueryDepthParamIndex()];
            }
            return queryDepth;
        }
    }

    class DeleteByQuery
    implements RepositoryQuery {
        DeleteByQuery() {
        }

        public Object execute(Object[] parameters) {
            Filters filters = DerivedGraphRepositoryQuery.this.resolveParams(parameters);
            Class<?> returnType = DerivedGraphRepositoryQuery.this.graphQueryMethod.resolveConcreteReturnType();
            if (returnType.equals(Long.class)) {
                if (DerivedGraphRepositoryQuery.this.graphQueryMethod.isCollectionQuery()) {
                    return DerivedGraphRepositoryQuery.this.session.delete(DerivedGraphRepositoryQuery.this.info.getJavaType(), (Iterable)filters, true);
                }
                return DerivedGraphRepositoryQuery.this.session.delete(DerivedGraphRepositoryQuery.this.info.getJavaType(), (Iterable)filters, false);
            }
            throw new RuntimeException("Long or Iterable<Long> is required as the return type of a Delete query");
        }

        public QueryMethod getQueryMethod() {
            return DerivedGraphRepositoryQuery.this.graphQueryMethod;
        }
    }

    class CountByQuery
    implements RepositoryQuery {
        CountByQuery() {
        }

        public Object execute(Object[] parameters) {
            if (this.getQueryMethod().getReturnedObjectType().equals(Long.class)) {
                Filters filters = DerivedGraphRepositoryQuery.this.resolveParams(parameters);
                return DerivedGraphRepositoryQuery.this.session.count(DerivedGraphRepositoryQuery.this.info.getJavaType(), (Iterable)filters);
            }
            throw new RuntimeException("Long is required as the return type of a Count query");
        }

        public QueryMethod getQueryMethod() {
            return DerivedGraphRepositoryQuery.this.graphQueryMethod;
        }
    }
}

