/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.neo4j.config.NullTransactionManager;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.Neo4jEmbeddedTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.UserTransactionAdapter;

public class JtaTransactionManagerFactoryBean
implements FactoryBean<JtaTransactionManager> {
    private final JtaTransactionManager jtaTransactionManager;
    static Constructor springTxManagerConstructor;

    public JtaTransactionManagerFactoryBean(GraphDatabaseService gds) {
        this.jtaTransactionManager = this.create(gds);
    }

    public JtaTransactionManager getObject() {
        return this.jtaTransactionManager;
    }

    public Class<JtaTransactionManager> getObjectType() {
        return JtaTransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private JtaTransactionManager create(GraphDatabaseService gds) {
        if (gds instanceof GraphDatabase) {
            return this.createJtaTransactionManager((GraphDatabase)gds);
        }
        if (gds instanceof GraphDatabaseAPI && springTxManagerConstructor == null) {
            return this.createJtaTransactionManager(new Neo4jEmbeddedTransactionManager(gds));
        }
        try {
            return this.createJtaTransactionManager((TransactionManager)springTxManagerConstructor.newInstance(gds));
        }
        catch (Exception exception) {
            return this.createEmbeddedJtaTransactionManager(gds);
        }
    }

    private JtaTransactionManager createJtaTransactionManager(GraphDatabase gdb) {
        return this.createJtaTransactionManager(gdb.getTransactionManager());
    }

    private JtaTransactionManager createJtaTransactionManager(TransactionManager transactionManager) {
        UserTransactionAdapter userTransaction = new UserTransactionAdapter(transactionManager);
        return new JtaTransactionManager((UserTransaction)userTransaction, transactionManager);
    }

    private JtaTransactionManager createNullJtaTransactionManager() {
        NullTransactionManager transactionManager = new NullTransactionManager();
        UserTransactionAdapter userTransaction = new UserTransactionAdapter((TransactionManager)transactionManager);
        return new JtaTransactionManager((UserTransaction)userTransaction, (TransactionManager)transactionManager);
    }

    private JtaTransactionManager createEmbeddedJtaTransactionManager(GraphDatabaseService gds) {
        Neo4jEmbeddedTransactionManager transactionManager = new Neo4jEmbeddedTransactionManager(gds);
        UserTransactionAdapter userTransaction = new UserTransactionAdapter((TransactionManager)transactionManager);
        return new JtaTransactionManager((UserTransaction)userTransaction, (TransactionManager)transactionManager);
    }

    private JtaTransactionManager createJtaTransactionManager(GraphDatabaseService gds) {
        TransactionManager transactionManager = this.createTransactionManagerForOnePointEight(gds);
        UserTransaction userTransaction = this.createUserTransactionForOnePointEight(gds);
        return new JtaTransactionManager(userTransaction, transactionManager);
    }

    private TransactionManager createTransactionManagerForOnePointEight(GraphDatabaseService gds) {
        return (TransactionManager)this.createDynamically(this.classFor("org.neo4j.kernel.impl.transaction.SpringTransactionManager"), GraphDatabaseAPI.class, gds);
    }

    private UserTransaction createUserTransactionForOnePointEight(GraphDatabaseService gds) {
        return (UserTransaction)this.createDynamically(this.classFor("org.neo4j.kernel.impl.transaction.UserTransactionImpl"), GraphDatabaseAPI.class, gds);
    }

    private <T> Class<T> classFor(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Class not found", cnfe);
        }
    }

    private boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private <T> T createDynamically(Class<T> requiredClass, Class<?> argumentClass, Object gds) {
        try {
            return requiredClass.getDeclaredConstructor(argumentClass).newInstance(gds);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error accessing constructor of class " + requiredClass + " for parameter type " + argumentClass, e);
        }
    }

    static {
        try {
            springTxManagerConstructor = Class.forName("org.neo4j.kernel.impl.transaction.SpringTransactionManager").getConstructor(GraphDatabaseAPI.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            springTxManagerConstructor = null;
        }
    }
}

