/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.core.UpdateableState;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.EntityStateFactory;

public class SourceStateTransmitter<S extends PropertyContainer> {
    private final EntityStateFactory<S> entityStateFactory;

    public SourceStateTransmitter(EntityStateFactory<S> entityStateFactory) {
        this.entityStateFactory = entityStateFactory;
    }

    public Object copyPropertiesFrom(final PersistentPropertyAccessor wrapper, S source, Neo4jPersistentEntity persistentEntity, MappingPolicy mappingPolicy, Neo4jTemplate template) {
        Object entity = wrapper.getBean();
        final EntityState<S> entityState = this.entityStateFactory.getEntityState(entity, false, template);
        entityState.setPersistentState(source);
        persistentEntity.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

            public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                SourceStateTransmitter.this.copyEntityStatePropertyValue(property, entityState, wrapper, property.getMappingPolicy());
            }
        });
        persistentEntity.doWithAssociations((AssociationHandler)new AssociationHandler<Neo4jPersistentProperty>(){

            public void doWithAssociation(Association<Neo4jPersistentProperty> association) {
                Neo4jPersistentProperty property = (Neo4jPersistentProperty)association.getInverse();
                SourceStateTransmitter.this.copyEntityStatePropertyValue(property, entityState, wrapper, property.getMappingPolicy());
            }
        });
        return entity;
    }

    private <R> void setEntityStateValue(Neo4jPersistentProperty property, EntityState<S> entityState, PersistentPropertyAccessor wrapper, MappingPolicy mappingPolicy) {
        if (!entityState.isWritable(property)) {
            return;
        }
        Object value = this.getProperty(wrapper, property);
        entityState.setValue(property, value, mappingPolicy);
    }

    private <R> Object getProperty(PersistentPropertyAccessor wrapper, Neo4jPersistentProperty property) {
        try {
            return wrapper.getProperty((PersistentProperty)property);
        }
        catch (Exception e) {
            throw new MappingException("Error retrieving property " + property.getName() + " from " + wrapper.getBean(), (Throwable)e);
        }
    }

    public <R> void setProperty(PersistentPropertyAccessor wrapper, Neo4jPersistentProperty property, Object value) {
        try {
            wrapper.setProperty((PersistentProperty)property, value);
        }
        catch (Exception e) {
            throw new MappingException("Setting property " + property.getName() + " to " + value + " on " + wrapper.getBean(), (Throwable)e);
        }
    }

    private <R> Object copyEntityStatePropertyValue(Neo4jPersistentProperty property, EntityState<S> nodeState, PersistentPropertyAccessor wrapper, MappingPolicy mappingPolicy) {
        Object value = DoReturn.unwrap(nodeState.getValue(property, mappingPolicy));
        this.setProperty(wrapper, property, value);
        return value;
    }

    public <R> void copyPropertiesTo(final PersistentPropertyAccessor wrapper, S target, Neo4jPersistentEntity persistentEntity, MappingPolicy mappingPolicy, Neo4jTemplate template) {
        try (Transaction tx = template.getGraphDatabase().beginTx();){
            final EntityState<S> entityState = this.entityStateFactory.getEntityState(wrapper.getBean(), false, template);
            if (target instanceof UpdateableState) {
                ((UpdateableState)target).track();
            }
            entityState.setPersistentState(target);
            entityState.persist();
            persistentEntity.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

                public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                    SourceStateTransmitter.this.setEntityStateValue(property, entityState, wrapper, property.getMappingPolicy());
                }
            });
            if (target instanceof UpdateableState) {
                ((UpdateableState)target).flush();
            }
            persistentEntity.doWithAssociations((AssociationHandler)new AssociationHandler<Neo4jPersistentProperty>(){

                public void doWithAssociation(Association<Neo4jPersistentProperty> association) {
                    Neo4jPersistentProperty property = (Neo4jPersistentProperty)association.getInverse();
                    SourceStateTransmitter.this.setEntityStateValue(property, entityState, wrapper, property.getMappingPolicy());
                }
            });
            tx.success();
        }
    }
}

