/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.repository.GraphRepositoryFactory;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;

public class Neo4jCdiRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<GraphDatabase> graphDatabase;

    public Neo4jCdiRepositoryBean(Bean<GraphDatabase> graphDatabase, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, CustomRepositoryImplementationDetector detector) {
        super(qualifiers, repositoryType, beanManager, detector);
        this.graphDatabase = graphDatabase;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Object customImplementation) {
        Neo4jMappingContext neo4jMapCtx = new Neo4jMappingContext();
        Neo4jTemplate neo4jTemplate = new Neo4jTemplate((GraphDatabase)this.getDependencyInstance(this.graphDatabase, GraphDatabase.class));
        GraphRepositoryFactory factory = new GraphRepositoryFactory(neo4jTemplate, neo4jMapCtx);
        return (T)factory.getRepository(repositoryType, customImplementation);
    }
}

