/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.util.Assert;

public class RelationshipHelper {
    private final Neo4jTemplate template;
    private final Direction direction;
    private final RelationshipType type;

    public RelationshipHelper(Neo4jTemplate template, Direction direction, RelationshipType type) {
        this.template = template;
        this.direction = direction;
        this.type = type;
    }

    private Iterable<Node> getOtherNodes(Node node) {
        HashSet<Node> result = new HashSet<Node>();
        for (Relationship rel : node.getRelationships(this.type, this.direction)) {
            result.add(rel.getOtherNode(node));
        }
        return result;
    }

    private Long getOtherNodeId(Node node, Relationship rel) {
        long id = node.getId();
        if (rel.getStartNode().getId() == id) {
            return rel.getEndNode().getId();
        }
        if (rel.getEndNode().getId() == id) {
            return rel.getStartNode().getId();
        }
        throw new IllegalStateException("Node " + node + " is not connected to Relationship " + rel);
    }

    private Iterable<Long> getOtherNodeIds(Node node) {
        HashSet<Long> result = new HashSet<Long>();
        for (Relationship rel : node.getRelationships(this.type, this.direction)) {
            result.add(this.getOtherNodeId(node, rel));
        }
        return result;
    }

    protected Node checkAndGetNode(Object entity) {
        if (entity == null) {
            throw new IllegalStateException("Entity is null");
        }
        Node node = this.getNode(entity);
        if (node != null) {
            return node;
        }
        throw new IllegalStateException("Entity must have a backing Node");
    }

    protected void removeMissingRelationshipsInStoreAndKeepOnlyNewRelationShipsInSet(Node node, Set<Node> targetNodes, Class<?> targetType) {
        Neo4jMappingContext mappingContext = this.template.getInfrastructure().getMappingContext();
        for (Relationship relationship : node.getRelationships(this.type, this.direction)) {
            Node otherNode = relationship.getOtherNode(node);
            if (targetNodes.remove(otherNode)) continue;
            if (targetType != null) {
                Object actualTargetType = this.determineEndNodeType(otherNode);
                try {
                    Neo4jPersistentEntity<?> persistentEntity = mappingContext.getPersistentEntity(actualTargetType);
                    if (!targetType.isAssignableFrom(persistentEntity.getType())) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Could not read type '%s' - type does not exist", actualTargetType), e);
                }
            }
            this.template.delete(relationship);
        }
    }

    private Object determineEndNodeType(Node otherNode) {
        Object actualTargetType = otherNode.getProperty("__type__", null);
        if (actualTargetType == null) {
            actualTargetType = this.tryDetermineTypeAssumingLabelBasedStrategy(otherNode);
        }
        if (actualTargetType == null) {
            throw new RuntimeException("Neither a property or Label could be found to work out what the type of the node is at the other end of the relationship ");
        }
        return actualTargetType;
    }

    private Object tryDetermineTypeAssumingLabelBasedStrategy(Node otherNode) {
        for (Label l : otherNode.getLabels()) {
            if (!l.name().startsWith("_")) continue;
            return l.name().substring("_".length());
        }
        return null;
    }

    protected void createAddedRelationships(Node node, Set<Node> targetNodes) {
        for (Node targetNode : targetNodes) {
            this.createSingleRelationship(node, targetNode);
        }
    }

    protected Set<Node> createSetOfTargetNodes(Object newVal, Class<?> relatedType) {
        if (!(newVal instanceof Set)) {
            throw new IllegalArgumentException("New value must be a Set, was: " + newVal.getClass());
        }
        HashSet<Node> nodes = new HashSet<Node>();
        for (Object value : (Set)newVal) {
            if (!relatedType.isInstance(value)) {
                throw new IllegalArgumentException("New value elements must be " + relatedType);
            }
            nodes.add(this.getOrCreateState(value));
        }
        return nodes;
    }

    protected Node getOrCreateState(Object value) {
        Node node = this.getNode(value);
        if (node != null) {
            return node;
        }
        Object saved = this.template.save(value);
        Node newState = this.getNode(saved);
        Assert.notNull((Object)newState);
        return newState;
    }

    protected Set<Object> createEntitySetFromRelationshipEndNodes(Object entity, MappingPolicy mappingPolicy, Class<?> relatedType) {
        Iterable<Node> nodes = this.getStatesFromEntity(entity);
        HashSet<Object> result = new HashSet<Object>();
        for (Node otherNode : nodes) {
            Object target = this.template.createEntityFromState(otherNode, relatedType, mappingPolicy);
            result.add(target);
        }
        return result;
    }

    protected Relationship createSingleRelationship(Node start, Node end) {
        if (end == null) {
            return null;
        }
        Map<String, Object> props = Collections.emptyMap();
        return this.template.getOrCreateRelationship(start, end, this.type, this.direction, props);
    }

    protected Iterable<Node> getStatesFromEntity(Object entity) {
        Node node = this.getNode(entity);
        return this.getOtherNodes(node);
    }

    protected Node getNode(Object entity) {
        return (Node)this.template.getPersistentState(entity);
    }

    public Iterable<Relationship> getRelationships(Node node) {
        return node.getRelationships(this.type, this.direction);
    }

    public Relationship getSingleRelationship(Node node) {
        return node.getSingleRelationship(this.type, this.direction);
    }

    public RelationshipType getRelationshipType() {
        return this.type;
    }
}

