/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.auditing.config.IsNewAwareAuditingHandlerBeanDefinitionParser;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.neo4j.lifecycle.AuditingEventListener;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class Neo4jAuditingBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MAPPING_CONTEXT = "neo4jMappingContext";

    protected Class<?> getBeanClass(Element element) {
        return AuditingEventListener.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder auditingListenerBuilder) {
        String ctxRef = element.getAttribute("mapping-context-ref");
        if (!StringUtils.hasText((String)ctxRef)) {
            ctxRef = MAPPING_CONTEXT;
        }
        IsNewAwareAuditingHandlerBeanDefinitionParser auditingHandlerParser = new IsNewAwareAuditingHandlerBeanDefinitionParser(ctxRef);
        auditingHandlerParser.parse(element, parserContext);
        auditingListenerBuilder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)auditingHandlerParser.getResolvedBeanName(), (Object)parserContext.extractSource((Object)element)));
    }
}

