/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.apache.lucene.search.NumericRangeQuery;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.AbstractGraphRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.NoSuchIndexException;
import org.springframework.data.neo4j.support.index.NullReadableIndex;

@Deprecated
public class LegacyIndexSearcher<S extends PropertyContainer, T> {
    private final Neo4jTemplate template;
    private final Class<T> clazz;

    LegacyIndexSearcher(Neo4jTemplate template, Class<T> clazz) {
        this.template = template;
        this.clazz = clazz;
    }

    public <T> Result<T> geoQuery(String indexName, String geoQuery, Object params) {
        IndexHits indexHits = this.getIndex(indexName, null).query(geoQuery, params);
        IndexHitsWrapper wrapper = new IndexHitsWrapper(indexHits);
        return this.template.convert(wrapper);
    }

    private ReadableIndex<S> getIndex(String indexName, String property) {
        try {
            if (indexName != null) {
                return this.template.getIndex(indexName, this.clazz);
            }
            return this.template.getIndex(this.clazz, property);
        }
        catch (NoSuchIndexException nsie) {
            return new NullReadableIndex(nsie.getIndex(), this.template.getGraphDatabaseService());
        }
    }

    private T createEntity(S node) {
        return this.template.createEntityFromState(node, this.clazz, this.template.getMappingPolicy(this.clazz));
    }

    private IndexHits<S> getIndexHits(String indexName, String propertyName, Object value) {
        Neo4jPersistentProperty property = this.template.getPersistentProperty(this.clazz, propertyName);
        if (value instanceof Number && (property == null || property.getIndexInfo().isNumeric())) {
            Number number = (Number)value;
            return this.getIndex(indexName, propertyName).query(propertyName, this.createInclusiveRangeQuery(propertyName, number, number));
        }
        return this.getIndex(indexName, propertyName).get(propertyName, value);
    }

    private ClosableIterable<T> query(String indexName, AbstractGraphRepository.Query<S> query) {
        try {
            IndexHits<S> indexHits = query.query(this.getIndex(indexName, null));
            if (indexHits == null) {
                return this.emptyClosableIterable();
            }
            return new IndexHitsWrapper(indexHits);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private ClosableIterable<T> emptyClosableIterable() {
        return AbstractGraphRepository.EMPTY_CLOSABLE_ITERABLE;
    }

    protected <T extends Number> NumericRangeQuery<T> createInclusiveRangeQuery(String property, Number from, Number to) {
        if (from instanceof Long) {
            return NumericRangeQuery.newLongRange((String)property, (Long)from.longValue(), (Long)to.longValue(), (boolean)true, (boolean)true);
        }
        if (from instanceof Integer) {
            return NumericRangeQuery.newIntRange((String)property, (Integer)from.intValue(), (Integer)to.intValue(), (boolean)true, (boolean)true);
        }
        if (from instanceof Double) {
            return NumericRangeQuery.newDoubleRange((String)property, (Double)from.doubleValue(), (Double)to.doubleValue(), (boolean)true, (boolean)true);
        }
        if (from instanceof Float) {
            return NumericRangeQuery.newFloatRange((String)property, (Float)Float.valueOf(from.floatValue()), (Float)Float.valueOf(to.floatValue()), (boolean)true, (boolean)true);
        }
        return NumericRangeQuery.newIntRange((String)property, (Integer)from.intValue(), (Integer)to.intValue(), (boolean)true, (boolean)true);
    }

    public Result<T> findAllByRange(String indexName, final String property, final Number from, final Number to) {
        return this.queryResult(indexName, new AbstractGraphRepository.Query<S>(){

            @Override
            public IndexHits<S> query(ReadableIndex<S> index) {
                return index.query(property, LegacyIndexSearcher.this.createInclusiveRangeQuery(property, from, to));
            }
        });
    }

    public Result<T> findAllByQuery(final String indexName, final String property, final Object query) {
        return this.queryResult(indexName, new AbstractGraphRepository.Query<S>(){

            @Override
            public IndexHits<S> query(ReadableIndex<S> index) {
                return LegacyIndexSearcher.this.getIndex(indexName, property).query(property, query);
            }
        });
    }

    public T findByPropertyValue(String indexName, String property, Object value) {
        try {
            PropertyContainer result = (PropertyContainer)this.getIndexHits(indexName, property, value).getSingle();
            if (result == null) {
                return null;
            }
            return this.createEntity(result);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public Result<T> findAllByPropertyValue(final String indexName, final String property, final Object value) {
        return this.queryResult(indexName, new AbstractGraphRepository.Query<S>(){

            @Override
            public IndexHits<S> query(ReadableIndex<S> index) {
                return LegacyIndexSearcher.this.getIndexHits(indexName, property, value);
            }
        });
    }

    private Result<T> queryResult(String indexName, AbstractGraphRepository.Query<S> query) {
        try {
            IndexHits<S> indexHits = query.query(this.getIndex(indexName, null));
            return this.template.convert(indexHits).to(this.clazz);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private class IndexHitsWrapper
    extends IterableWrapper<T, S>
    implements ClosableIterable<T> {
        private final IndexHits<S> indexHits;

        public IndexHitsWrapper(IndexHits<S> indexHits) {
            super(indexHits);
            this.indexHits = indexHits;
        }

        protected T underlyingObjectToObject(S result) {
            return LegacyIndexSearcher.this.createEntity(result);
        }

        public void close() {
            this.indexHits.close();
        }
    }
}

