/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.repository.query.IndexBasedStartClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;

public class ExactIndexBasedStartClause
extends IndexBasedStartClause {
    public ExactIndexBasedStartClause(PartInfo partInfo) {
        super(partInfo);
    }

    public String toString() {
        PartInfo partInfo = this.getPartInfo();
        String identifier = partInfo.getIdentifier();
        String indexName = partInfo.getIndexName();
        String parameterIndex = partInfo.getParamName();
        return String.format(QueryTemplates.START_CLAUSE_INDEX_LOOKUP, identifier, indexName, partInfo.getNeo4jPropertyName(), parameterIndex);
    }

    @Override
    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters, Neo4jTemplate template) {
        Map<Parameter, PartInfo> myParameters = this.findMyParameters(parameters.keySet());
        LinkedHashMap<Parameter, Object> result = new LinkedHashMap<Parameter, Object>(parameters);
        result.keySet().removeAll(myParameters.keySet());
        Map<PartInfo, Object> values = this.matchToPartsAndConvert(myParameters, parameters, template);
        Parameter firstParam = (Parameter)IteratorUtil.first(myParameters.keySet());
        Object value = IteratorUtil.first(values.values());
        result.put(firstParam, value);
        return result;
    }
}

