/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class RelationshipInfo {
    private boolean isCollection;
    private final Direction direction;
    private final String type;
    private final TypeInformation<?> targetType;
    private final boolean relatedTo;
    private boolean readonly;
    private Neo4jPersistentEntity targetEntity;

    public Direction getDirection() {
        return this.direction;
    }

    public String getType() {
        return this.type;
    }

    public RelationshipType getRelationshipType() {
        return DynamicRelationshipType.withName((String)this.type);
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean isSingle() {
        return !this.isCollection;
    }

    public RelationshipInfo(String type, Direction direction, TypeInformation<?> typeInformation, TypeInformation<?> concreteActualType, Neo4jMappingContext ctx) {
        this.type = type;
        this.direction = direction;
        this.isCollection = typeInformation.isCollectionLike();
        this.targetType = concreteActualType != null ? concreteActualType : typeInformation.getActualType();
        this.targetEntity = (Neo4jPersistentEntity)ctx.getPersistentEntity(this.targetType);
        this.relatedTo = this.targetEntity.isNodeEntity();
        this.readonly = this.isCollection() && typeInformation.getType().equals(Iterable.class);
    }

    public static RelationshipInfo fromField(String name, TypeInformation<?> typeInformation, Neo4jMappingContext ctx) {
        return new RelationshipInfo(name, Direction.OUTGOING, typeInformation, null, ctx);
    }

    public static RelationshipInfo fromField(String name, RelatedTo annotation, TypeInformation<?> typeInformation, Neo4jMappingContext ctx) {
        RelationshipInfo relationshipInfo = new RelationshipInfo(annotation.type().isEmpty() ? name : annotation.type(), annotation.direction(), typeInformation, (TypeInformation<?>)(annotation.elementClass() != Object.class ? ClassTypeInformation.from(annotation.elementClass()) : null), ctx);
        if (relationshipInfo.isRelatedToVia()) {
            throw new MappingException("Relationship field with NodeEntity " + relationshipInfo.getTargetEntity().getType() + " annotated with @RelatedTo");
        }
        return relationshipInfo;
    }

    public static RelationshipInfo fromField(String name, RelatedToVia annotation, TypeInformation<?> typeInformation, Neo4jMappingContext ctx) {
        TypeInformation<?> elementClass = RelationshipInfo.elementClass(annotation, typeInformation);
        RelationshipInfo relationshipInfo = new RelationshipInfo(RelationshipInfo.relationshipType(annotation, typeInformation), annotation.direction(), typeInformation, elementClass, ctx);
        if (relationshipInfo.isRelatedTo()) {
            throw new MappingException("Relationship field with RelationshipEntity " + relationshipInfo.getTargetEntity().getType() + " annotated with @RelatedToVia");
        }
        return relationshipInfo;
    }

    private static String relationshipType(RelatedToVia annotation, TypeInformation<?> typeInformation) {
        if (!annotation.type().isEmpty()) {
            return annotation.type();
        }
        TypeInformation<?> relationshipEntityType = RelationshipInfo.elementClass(annotation, typeInformation);
        RelationshipEntity relationshipEntity = relationshipEntityType.getType().getAnnotation(RelationshipEntity.class);
        if (relationshipEntity == null) {
            throw new MappingException(typeInformation.getType() + " is no RelationshipEntity");
        }
        if (relationshipEntity.type() == null || relationshipEntity.type().isEmpty()) {
            throw new MappingException("Relationship entity must have a default type");
        }
        return relationshipEntity.type();
    }

    private static TypeInformation<?> elementClass(RelatedToVia annotation, TypeInformation<?> typeInformation) {
        return annotation.elementClass() != Object.class ? ClassTypeInformation.from(annotation.elementClass()) : typeInformation.getActualType();
    }

    public TypeInformation<?> getTargetType() {
        return this.targetType;
    }

    public boolean isRelatedTo() {
        return this.relatedTo;
    }

    public boolean isRelatedToVia() {
        return !this.isRelatedTo();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public Neo4jPersistentEntity getTargetEntity() {
        return this.targetEntity;
    }
}

