/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.GeoQueries;
import org.springframework.data.neo4j.repository.query.IndexBasedStartClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;

public class SpatialIndexStartClause
extends IndexBasedStartClause {
    public SpatialIndexStartClause(PartInfo partInfo) {
        super(partInfo);
    }

    public String toString() {
        PartInfo partInfo = this.getPartInfo();
        String identifier = partInfo.getIdentifier();
        String indexName = partInfo.getIndexName();
        int parameterIndex = partInfo.getParameterIndex();
        return String.format(QueryTemplates.START_CLAUSE_INDEX_QUERY, identifier, indexName, parameterIndex);
    }

    @Override
    protected Object convertIfNecessary(Neo4jTemplate template, Object value, Neo4jPersistentProperty property) {
        return value;
    }

    @Override
    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters, Neo4jTemplate template) {
        Map<Parameter, PartInfo> myParameters = this.findMyParameters(parameters.keySet());
        LinkedHashMap<Parameter, Object> result = new LinkedHashMap<Parameter, Object>(parameters);
        result.keySet().removeAll(myParameters.keySet());
        Map<PartInfo, Object> values = this.matchToPartsAndConvert(myParameters, parameters, template);
        if (values.size() > 1) {
            throw new IllegalStateException("Can only support one spatial argument at this time, e.g. Circle, Box, Polygon or WKT-String");
        }
        Parameter firstParam = (Parameter)IteratorUtil.first(myParameters.keySet());
        result.put(firstParam, this.renderQuery(values));
        return result;
    }

    protected String renderQuery(Map<PartInfo, Object> values) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<PartInfo, Object> entry : values.entrySet()) {
            Pair<String, String> queryParams = GeoQueries.toQueryParams(entry.getKey().getType(), entry.getValue());
            sb.append((String)queryParams.first()).append(":").append((String)queryParams.other());
        }
        return sb.toString();
    }
}

