/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.ClosableIterable;

public class WrappedIterableClosableIterable<S>
implements ClosableIterable {
    private Iterable<S> iterable;
    private boolean canBeClosed;
    private List<ResourceIterator> openedResourceIterators;

    public WrappedIterableClosableIterable(Iterable<S> iterable) {
        this.iterable = iterable;
        this.canBeClosed = iterable instanceof ResourceIterable || iterable instanceof ClosableIterable;
        this.openedResourceIterators = new ArrayList<ResourceIterator>();
    }

    public void close() {
        if (this.canBeClosed) {
            if (this.iterable instanceof ClosableIterable) {
                ((ClosableIterable)this.iterable).close();
            }
            for (ResourceIterator ri : this.openedResourceIterators) {
                ri.close();
            }
        }
        this.openedResourceIterators = null;
        this.iterable = null;
    }

    public Iterator iterator() {
        Iterator<S> it = this.iterable.iterator();
        if (it instanceof ResourceIterator) {
            this.openedResourceIterators.add((ResourceIterator)it);
        }
        return it;
    }
}

