/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.PrefixedDynamicProperties;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class ManagedPrefixedDynamicProperties
extends PrefixedDynamicProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Object entity;
    private final transient Neo4jTemplate template;
    private final transient FieldAccessor fieldAccessor;
    private final transient Neo4jPersistentProperty property;
    private transient boolean isNode;
    private transient MappingPolicy mappingPolicy;

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public ManagedPrefixedDynamicProperties(String prefix, Neo4jPersistentProperty property, Object entity, Neo4jTemplate template, FieldAccessor fieldAccessor, MappingPolicy mappingPolicy) {
        this(prefix, 10, property, entity, template, fieldAccessor, mappingPolicy);
    }

    public ManagedPrefixedDynamicProperties(String prefix, int initialCapacity, Neo4jPersistentProperty property, Object entity, Neo4jTemplate template, FieldAccessor fieldAccessor, MappingPolicy mappingPolicy) {
        super(prefix, initialCapacity);
        this.property = property;
        this.entity = entity;
        this.template = template;
        this.fieldAccessor = fieldAccessor;
        this.isNode = property.getOwner().isNodeEntity();
        this.mappingPolicy = mappingPolicy;
    }

    public static ManagedPrefixedDynamicProperties create(String prefix, Neo4jPersistentProperty property, Object entity, Neo4jTemplate template, FieldAccessor fieldAccessor, MappingPolicy mappingPolicy) {
        return new ManagedPrefixedDynamicProperties(prefix, property, entity, template, fieldAccessor, mappingPolicy);
    }

    @Override
    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
        this.update();
    }

    @Override
    public Object removeProperty(String key) {
        Object o = super.removeProperty(key);
        this.update();
        return o;
    }

    @Override
    public void setPropertiesFrom(Map<String, Object> map) {
        super.setPropertiesFrom(map);
        this.update();
    }

    @Override
    public DynamicProperties createFrom(Map<String, Object> map) {
        ManagedPrefixedDynamicProperties d = new ManagedPrefixedDynamicProperties(this.prefix, map.size(), this.property, this.entity, this.template, this.fieldAccessor, this.property.getMappingPolicy());
        d.setPropertiesFrom(map);
        return d;
    }

    private Object updateValue() {
        Object newValue = this.fieldAccessor.setValue(this.entity, this, this.mappingPolicy);
        if (newValue instanceof DoReturn) {
            return DoReturn.unwrap(newValue);
        }
        this.property.setValue(this.entity, newValue);
        return newValue;
    }

    private void update() {
        if (this.template.isManaged(this.entity)) {
            this.updateValueWithState(((ManagedEntity)this.entity).getEntityState());
        } else {
            this.updateValue();
        }
    }

    private Object updateValueWithState(EntityState entityState) {
        Object newValue = entityState.setValue(this.property, (Object)this, this.mappingPolicy);
        if (newValue instanceof DoReturn) {
            return DoReturn.unwrap(newValue);
        }
        this.property.setValue(this.entity, newValue);
        return newValue;
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map actualMapContent;
        private String prefix;

        SerializationProxy(ManagedPrefixedDynamicProperties prefixedDynamicProperties) {
            this.actualMapContent = prefixedDynamicProperties.asMap();
            this.prefix = prefixedDynamicProperties.prefix;
        }

        private Object readResolve() {
            PrefixedDynamicProperties val = new PrefixedDynamicProperties(this.prefix);
            val.setPropertiesFrom(this.actualMapContent);
            return val;
        }
    }
}

