/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class ManagedFieldAccessorSet<T>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Object entity;
    final transient Set<T> delegate;
    private final transient Neo4jPersistentProperty property;
    private final transient Neo4jTemplate ctx;
    private final transient FieldAccessor fieldAccessor;
    private final transient MappingPolicy mappingPolicy;

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public ManagedFieldAccessorSet(Object entity, Object newVal, Neo4jPersistentProperty property, Neo4jTemplate ctx, FieldAccessor fieldAccessor, MappingPolicy mappingPolicy) {
        this.entity = entity;
        this.property = property;
        this.ctx = ctx;
        this.fieldAccessor = fieldAccessor;
        this.delegate = (Set)newVal;
        this.mappingPolicy = mappingPolicy;
    }

    public static <T> ManagedFieldAccessorSet<T> create(Object entity, Set<T> result, MappingPolicy mappingPolicy, Neo4jPersistentProperty property, Neo4jTemplate template, FieldAccessor fieldAccessor) {
        return new ManagedFieldAccessorSet<T>(entity, result, property, template, fieldAccessor, mappingPolicy);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> iterator = this.delegate.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                ManagedFieldAccessorSet.this.update();
            }
        };
    }

    private void update() {
        if (this.ctx.isManaged(this.entity)) {
            this.updateValueWithState(((ManagedEntity)this.entity).getEntityState());
        } else {
            this.updateValue();
        }
    }

    private Object updateValueWithState(EntityState entityState) {
        Object newValue = entityState.setValue(this.property, this.delegate, this.mappingPolicy);
        if (newValue instanceof DoReturn) {
            return DoReturn.unwrap(newValue);
        }
        this.property.setValue(this.entity, newValue);
        return newValue;
    }

    private Object updateValue() {
        Object newValue = this.fieldAccessor.setValue(this.entity, this.delegate, this.mappingPolicy);
        if (newValue instanceof DoReturn) {
            return DoReturn.unwrap(newValue);
        }
        this.property.setValue(this.entity, newValue);
        return newValue;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(T e) {
        boolean res = this.delegate.add(e);
        if (res) {
            this.update();
        }
        return res;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.delegate.removeAll(c)) {
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.delegate.remove(o)) {
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.delegate.retainAll(c)) {
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.update();
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Set<T> delegateSet;

        SerializationProxy(ManagedFieldAccessorSet<T> managedFieldAccessorSet) {
            this.delegateSet = managedFieldAccessorSet.delegate;
        }

        private Object readResolve() {
            return this.delegateSet;
        }
    }
}

