/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.neo4j.conversion.ContainerConverter;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.Handler;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.mapping.MappingPolicy;

public class QueryResultBuilder<T>
implements Result<T> {
    private Iterable<T> result;
    private final ResultConverter defaultConverter;
    private final boolean isClosableIterable;
    private boolean isClosed;
    private MappingPolicy mappingPolicy;

    public QueryResultBuilder(Iterable<T> result) {
        this(result, new DefaultConverter());
    }

    public QueryResultBuilder(Iterable<T> result, ResultConverter<T, ?> defaultConverter) {
        this.result = result;
        this.isClosableIterable = result instanceof IndexHits || result instanceof ClosableIterable || result instanceof AutoCloseable;
        this.defaultConverter = defaultConverter;
    }

    @Override
    public <R> Result<R> to(Class<R> type) {
        return this.to(type, this.defaultConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T single() {
        try {
            Object object = IteratorUtil.single(this.result);
            return (T)object;
        }
        finally {
            this.closeIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T singleOrNull() {
        try {
            Object object = IteratorUtil.singleOrNull(this.result);
            return (T)object;
        }
        finally {
            this.closeIfNeeded();
        }
    }

    @Override
    public void finish() {
        this.closeIfNeeded();
    }

    @Override
    public <R> Result<R> to(final Class<R> type, final ResultConverter<T, R> resultConverter) {
        IterableWrapper it = new IterableWrapper<R, T>(this.result){

            protected R underlyingObjectToObject(T object) {
                return resultConverter.convert(object, type, QueryResultBuilder.this.mappingPolicy);
            }
        };
        return new QueryResultBuilder<T>(it, this.defaultConverter);
    }

    @Override
    public <C extends Iterable<T>> C as(Class<C> container) {
        return ContainerConverter.toContainer(container, this);
    }

    @Override
    public Slice<T> slice(Pageable page) {
        return ContainerConverter.slice(this, page);
    }

    @Override
    public Slice<T> slice(int page, int size) {
        return this.slice((Pageable)new PageRequest(page, size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Handler<T> handler) {
        try {
            for (T value : this.result) {
                handler.handle(value);
            }
        }
        finally {
            this.closeIfNeeded();
        }
    }

    private void closeIfNeeded() {
        if (this.isClosableIterable && !this.isClosed) {
            if (this.result instanceof IndexHits) {
                ((IndexHits)this.result).close();
            } else if (this.result instanceof ClosableIterable) {
                ((ClosableIterable)this.result).close();
            }
            this.isClosed = true;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.result.iterator();
    }

    @Override
    public Result<T> with(MappingPolicy mappingPolicy) {
        this.mappingPolicy = mappingPolicy;
        return this;
    }

    public static <T> QueryResultBuilder<T> from(Iterable<T> values) {
        return new QueryResultBuilder<T>(values);
    }

    public static <T> QueryResultBuilder<T> from(T ... values) {
        return QueryResultBuilder.from(Arrays.asList(values));
    }
}

