/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.fieldaccess.DefaultEntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class NodeEntityState
extends DefaultEntityState<Node> {
    private final Neo4jTemplate template;

    public NodeEntityState(Node underlyingState, Object entity, Class<? extends Object> type, Neo4jTemplate template, DelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory, Neo4jPersistentEntity<Object> persistentEntity) {
        super(underlyingState, entity, type, nodeDelegatingFieldAccessorFactory, persistentEntity);
        this.template = template;
    }

    @Override
    public void createAndAssignState() {
        if (this.hasPersistentState()) {
            if (log.isDebugEnabled()) {
                log.debug("Entity " + this.entity.getClass() + " already has persistent state " + this.getPersistentState());
            }
            return;
        }
        try {
            Object id = this.getIdFromEntity();
            if (id instanceof Number) {
                Node node = this.template.getNode(((Number)id).longValue());
                this.setPersistentState(node);
                if (log.isDebugEnabled()) {
                    log.debug("Entity reattached " + this.entity.getClass() + "; used Node [" + this.getPersistentState() + "];");
                }
                return;
            }
            Node node = this.persistentEntity.isUnique() ? this.template.createUniqueNode(this.entity) : this.template.createNode(null, this.persistentEntity.getAllLabels());
            this.setPersistentState(node);
            if (log.isDebugEnabled()) {
                log.debug("User-defined constructor called on class " + this.entity.getClass() + "; created Node [" + this.getPersistentState() + "]; Updating metamodel");
            }
            this.template.postEntityCreation(node, this.type);
        }
        catch (NotInTransactionException e) {
            throw new InvalidDataAccessResourceUsageException("Not in a Neo4j transaction.", (Throwable)e);
        }
    }

    @Override
    public void setPersistentState(Node node) {
        if (!(this.entity instanceof ManagedEntity)) {
            this.template.setPersistentState(this.entity, node);
        }
        super.setPersistentState(node);
    }

    @Override
    public Object persist() {
        if (this.getPersistentState() == null) {
            this.createAndAssignState();
        }
        return this.entity;
    }
}

