/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.neo4j.graphdb.PropertyContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;

class ValidatingPropertyFieldAccessorListenerFactory
implements FieldAccessorListenerFactory {
    private final Neo4jTemplate template;

    ValidatingPropertyFieldAccessorListenerFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return this.hasValidationAnnotation(property);
    }

    private boolean hasValidationAnnotation(Neo4jPersistentProperty property) {
        for (Annotation annotation : property.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FieldAccessListener forField(Neo4jPersistentProperty property) {
        return new ValidatingPropertyFieldAccessorListener(property, this.template.getValidator());
    }

    public static class ValidatingPropertyFieldAccessorListener<T extends PropertyContainer>
    implements FieldAccessListener {
        private static final Logger log = LoggerFactory.getLogger(ValidatingPropertyFieldAccessorListener.class);
        private String propertyName;
        private Validator validator;
        private Neo4jPersistentEntity<?> entityType;

        public ValidatingPropertyFieldAccessorListener(Neo4jPersistentProperty field, Validator validator) {
            this.propertyName = field.getName();
            this.entityType = field.getOwner();
            this.validator = validator;
        }

        @Override
        public void valueChanged(Object entity, Object oldVal, Object newVal) {
            if (this.validator == null) {
                return;
            }
            Class type = this.entityType.getType();
            Set constraintViolations = this.validator.validateValue(type, this.propertyName, newVal, new Class[0]);
            if (!constraintViolations.isEmpty()) {
                throw new ValidationException("Error validating field " + this.propertyName + " of " + this.entityType + ": " + constraintViolations);
            }
        }
    }
}

