/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.EnumSet;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.WhereClause;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.parser.Part;

public class IdPropertyWhereClause
extends WhereClause {
    public IdPropertyWhereClause(PartInfo partInfo, Neo4jTemplate template) {
        super(partInfo, template);
    }

    @Override
    public String toString() {
        String operator = (String)SYMBOLS.get(this.type);
        String variable = this.partInfo.getIdentifier();
        String result = String.format("id(`%1$s`) %2$s {%3$d}", variable, operator, this.partInfo.getParameterIndex());
        if (EnumSet.of(Part.Type.NOT_IN).contains(this.type)) {
            result = "not( " + result + " )";
        }
        return result;
    }

    @Override
    protected Object convertValue(PartInfo partInfo, Object value) {
        return value;
    }
}

