/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.config.IsNewAwareAuditingHandlerBeanDefinitionParser;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.neo4j.lifecycle.AuditingEventListener;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class Neo4jAuditingBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    static final String MAPPING_CONTEXT = "neo4jMappingContext";
    static final String IS_NEW_STRATEGY_FACTORY = "isNewStrategyFactory";

    protected Class<?> getBeanClass(Element element) {
        return AuditingEventListener.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder auditingListenerBuilder) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!registry.containsBeanDefinition(IS_NEW_STRATEGY_FACTORY)) {
            String templateName = MAPPING_CONTEXT;
            if (!registry.containsBeanDefinition(MAPPING_CONTEXT)) {
                templateName = Neo4jAuditingBeanDefinitionParser.resolveMappingContextRef(element);
            }
            this.createIsNewStrategyFactoryBeanDefinition(templateName, parserContext, element);
        }
        IsNewAwareAuditingHandlerBeanDefinitionParser isNewStrategyParser = new IsNewAwareAuditingHandlerBeanDefinitionParser(IS_NEW_STRATEGY_FACTORY);
        BeanDefinition isNewStrategyBeanDefinition = isNewStrategyParser.parse(element, parserContext);
        auditingListenerBuilder.addConstructorArgValue((Object)isNewStrategyBeanDefinition);
    }

    static String resolveMappingContextRef(Element element) {
        String ctxRef = element.getAttribute("mapping-context-ref");
        if (StringUtils.hasText((String)ctxRef)) {
            return ctxRef;
        }
        return MAPPING_CONTEXT;
    }

    private String createIsNewStrategyFactoryBeanDefinition(String mappingContextRef, ParserContext context, Element element) {
        BeanDefinitionBuilder mappingContextStrategyFactoryBuilder = BeanDefinitionBuilder.rootBeanDefinition(MappingContextIsNewStrategyFactory.class);
        mappingContextStrategyFactoryBuilder.addConstructorArgReference(mappingContextRef);
        BeanComponentDefinitionBuilder builder = new BeanComponentDefinitionBuilder(element, context);
        context.registerBeanComponent(builder.getComponent(mappingContextStrategyFactoryBuilder, IS_NEW_STRATEGY_FACTORY));
        return IS_NEW_STRATEGY_FACTORY;
    }
}

