/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.core.RelationshipTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.NoSuchIndexException;
import org.springframework.data.neo4j.support.typerepresentation.IndexingNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.NoopNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.NoopRelationshipTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategy;

public class TypeRepresentationStrategyFactory {
    private final GraphDatabase graphDatabaseService;
    private final Strategy strategy;
    private IndexProvider indexProvider;

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService) {
        this(graphDatabaseService, TypeRepresentationStrategyFactory.chooseStrategy(graphDatabaseService), null);
    }

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
        this(graphDatabaseService, TypeRepresentationStrategyFactory.chooseStrategy(graphDatabaseService), indexProvider);
    }

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService, Strategy strategy) {
        this.graphDatabaseService = graphDatabaseService;
        this.strategy = strategy;
    }

    public TypeRepresentationStrategyFactory(GraphDatabase graphDatabaseService, Strategy strategy, IndexProvider indexProvider) {
        this.indexProvider = indexProvider;
        this.graphDatabaseService = graphDatabaseService;
        this.strategy = strategy;
    }

    private static Strategy chooseStrategy(GraphDatabase graphDatabaseService) {
        if (TypeRepresentationStrategyFactory.isAlreadyIndexed(graphDatabaseService)) {
            return Strategy.Indexed;
        }
        if (TypeRepresentationStrategyFactory.isAlreadySubRef(graphDatabaseService)) {
            return Strategy.SubRef;
        }
        return Strategy.Indexed;
    }

    private static boolean isAlreadyIndexed(GraphDatabase graphDatabaseService) {
        try {
            Index index = graphDatabaseService.getIndex("__types__");
            return index != null && Node.class.isAssignableFrom(index.getEntityType());
        }
        catch (NoSuchIndexException nsie) {
            return false;
        }
    }

    private static boolean isAlreadySubRef(GraphDatabase graphDatabaseService) {
        try {
            for (Relationship rel : graphDatabaseService.getReferenceNode().getRelationships()) {
                if (!rel.getType().name().startsWith("SUBREF_")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy() {
        return this.strategy.getNodeTypeRepresentationStrategy(this.graphDatabaseService, this.indexProvider);
    }

    public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy() {
        return this.strategy.getRelationshipTypeRepresentationStrategy(this.graphDatabaseService, this.indexProvider);
    }

    public void setIndexProvider(IndexProvider indexProvider) {
        this.indexProvider = indexProvider;
    }

    public static enum Strategy {
        SubRef{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new SubReferenceNodeTypeRepresentationStrategy(graphDatabaseService);
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new NoopRelationshipTypeRepresentationStrategy();
            }
        }
        ,
        Indexed{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new IndexingNodeTypeRepresentationStrategy(graphDatabaseService, indexProvider);
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new IndexingRelationshipTypeRepresentationStrategy(graphDatabaseService, indexProvider);
            }
        }
        ,
        Noop{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new NoopNodeTypeRepresentationStrategy();
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase graphDatabaseService, IndexProvider indexProvider) {
                return new NoopRelationshipTypeRepresentationStrategy();
            }
        };


        public abstract NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabase var1, IndexProvider var2);

        public abstract RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabase var1, IndexProvider var2);
    }
}

