/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AbstractPersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.GraphProperty;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.mapping.IndexInfo;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.util.TypeInformation;

class Neo4jPersistentPropertyImpl
extends AbstractPersistentProperty<Neo4jPersistentProperty>
implements Neo4jPersistentProperty {
    private static final Logger log = LoggerFactory.getLogger(Neo4jPersistentProperty.class);
    private final RelationshipInfo relationshipInfo;
    private final boolean isIdProperty;
    private IndexInfo indexInfo;
    private Map<Class<? extends Annotation>, ? extends Annotation> annotations;
    private Association<Neo4jPersistentProperty> myAssociation;
    private String defaultValue;
    private Class<?> propertyType;
    private String query;
    private final boolean isNeo4jEntityType;
    private final Boolean isAssociation;
    private final String neo4jPropertyName;
    private final int hash = this.getField().hashCode();
    private final boolean isVersionProperty;

    public Neo4jPersistentPropertyImpl(Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, Neo4jPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, Neo4jMappingContext ctx) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        this.annotations = this.extractAnnotations(field);
        this.relationshipInfo = this.extractRelationshipInfo(field, ctx);
        this.propertyType = this.extractPropertyType();
        this.isAssociation = ctx.isReference(this);
        this.isNeo4jEntityType = Neo4jPersistentPropertyImpl.isNeo4jPropertyType(this.getType());
        this.neo4jPropertyName = this.createNeo4jPropertyName();
        this.indexInfo = this.extractIndexInfo();
        this.isIdProperty = this.annotations.containsKey(GraphId.class);
        this.defaultValue = this.extractDefaultValue();
        this.myAssociation = this.isAssociation() ? (super.getAssociation() == null ? this.createAssociation() : super.getAssociation()) : null;
        this.query = this.extractQuery();
        this.isVersionProperty = this.isAnnotationPresent(Version.class);
    }

    private String extractQuery() {
        Query query = this.getAnnotation(Query.class);
        if (query == null) {
            return null;
        }
        String value = query.value();
        return value.trim().isEmpty() ? null : value;
    }

    private Class<?> extractPropertyType() {
        GraphProperty graphProperty = this.getAnnotation(GraphProperty.class);
        if (graphProperty == null) {
            return String.class;
        }
        return graphProperty.propertyType();
    }

    private String extractDefaultValue() {
        GraphProperty graphProperty = this.getAnnotation(GraphProperty.class);
        if (graphProperty == null) {
            return null;
        }
        String value = graphProperty.defaultValue();
        if (value.equals("\u0000")) {
            return null;
        }
        return value;
    }

    public Association<Neo4jPersistentProperty> getAssociation() {
        return this.myAssociation;
    }

    private Map<Class<? extends Annotation>, ? extends Annotation> extractAnnotations(Field field) {
        IdentityHashMap<Class<? extends Annotation>, Annotation> result = new IdentityHashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : field.getAnnotations()) {
            result.put(annotation.annotationType(), annotation);
        }
        return result;
    }

    private IndexInfo extractIndexInfo() {
        Indexed annotation = this.getAnnotation(Indexed.class);
        return annotation != null ? new IndexInfo(annotation, this) : null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<? extends T> annotationType) {
        return this.findAnnotation(annotationType);
    }

    public <A extends Annotation> A findAnnotation(Class<? extends A> annotationType) {
        return (A)this.annotations.get(annotationType);
    }

    private RelationshipInfo extractRelationshipInfo(Field field, Neo4jMappingContext ctx) {
        if (this.isAnnotationPresent(RelatedTo.class)) {
            return RelationshipInfo.fromField(field, this.getAnnotation(RelatedTo.class), this.getTypeInformation(), ctx);
        }
        if (this.isAnnotationPresent(RelatedToVia.class)) {
            return RelationshipInfo.fromField(field, this.getAnnotation(RelatedToVia.class), this.getTypeInformation(), ctx);
        }
        if (Neo4jPersistentPropertyImpl.hasAnnotation(this.getTypeInformation(), NodeEntity.class)) {
            return RelationshipInfo.fromField(field, this.getTypeInformation(), ctx);
        }
        return null;
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    @Override
    public void setValue(Object entity, Object newValue) {
        try {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
            this.field.set(entity, newValue);
        }
        catch (IllegalAccessException e) {
            throw new MappingException("Could not access field " + this.field + " for setting value " + newValue + " on " + this);
        }
    }

    private static boolean hasAnnotation(TypeInformation<?> typeInformation, Class<NodeEntity> annotationClass) {
        return typeInformation.getActualType().getType().isAnnotationPresent(annotationClass);
    }

    public boolean isIdProperty() {
        return this.isIdProperty;
    }

    public boolean isVersionProperty() {
        return this.isVersionProperty;
    }

    protected Association<Neo4jPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    public boolean isAssociation() {
        return this.isAssociation == null ? super.isAssociation() : this.isAssociation != false || this.isRelationship();
    }

    @Override
    public boolean isRelationship() {
        return this.relationshipInfo != null;
    }

    @Override
    public RelationshipInfo getRelationshipInfo() {
        return this.relationshipInfo;
    }

    @Override
    public boolean isIndexed() {
        return this.indexInfo != null;
    }

    @Override
    public IndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    @Override
    public String getNeo4jPropertyName() {
        return this.neo4jPropertyName;
    }

    private String createNeo4jPropertyName() {
        PersistentEntity entityClass = this.getOwner();
        if (entityClass.useShortNames()) {
            return this.getName();
        }
        return String.format("%s.%s", entityClass.getType().getSimpleName(), this.getName());
    }

    @Override
    public boolean isSerializablePropertyField(ConversionService conversionService) {
        if (this.isRelationship()) {
            return false;
        }
        Class type = this.getType();
        if (this.getTypeInformation().isCollectionLike()) {
            return this.isConvertible(conversionService, this.getComponentType());
        }
        return this.isConvertible(conversionService, type);
    }

    private boolean isConvertible(ConversionService conversionService, Class<?> type) {
        return conversionService.canConvert(type, this.propertyType) && conversionService.canConvert(this.propertyType, type);
    }

    @Override
    public boolean isNeo4jPropertyType() {
        return this.isNeo4jEntityType;
    }

    public static boolean isNumeric(Class<?> fieldType) {
        return fieldType.isPrimitive() && !fieldType.equals(Boolean.TYPE) && !fieldType.equals(Void.TYPE) || fieldType.equals(Character.class) || fieldType.getName().startsWith("java.lang") && Number.class.isAssignableFrom(fieldType);
    }

    @Override
    public boolean isIndexedNumerically() {
        if (!this.isIndexed() || !this.getIndexInfo().isNumeric()) {
            return false;
        }
        return Neo4jPersistentPropertyImpl.isNumeric(this.getType()) || Neo4jPersistentPropertyImpl.isNumeric(this.getPropertyType()) || this.getType().isArray() && !this.getType().getComponentType().isArray() && Neo4jPersistentPropertyImpl.isNumeric(this.getType().getComponentType());
    }

    private static boolean isNeo4jPropertyType(Class<?> fieldType) {
        return fieldType.equals(String.class) || fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE) || Neo4jPersistentPropertyImpl.isNumeric(fieldType) || fieldType.isArray() && !fieldType.getComponentType().isArray() && Neo4jPersistentPropertyImpl.isNeo4jPropertyType(fieldType.getComponentType());
    }

    @Override
    public boolean isNeo4jPropertyValue(Object value) {
        if (value == null || value.getClass().isArray()) {
            return false;
        }
        return Neo4jPersistentPropertyImpl.isNeo4jPropertyType(value.getClass());
    }

    @Override
    public boolean isSyntheticField() {
        return this.getName().contains("$");
    }

    @Override
    public Collection<? extends Annotation> getAnnotations() {
        return this.annotations.values();
    }

    @Override
    public Object getValue(Object entity, MappingPolicy mappingPolicy) {
        if (entity instanceof ManagedEntity && !mappingPolicy.accessField()) {
            return DoReturn.unwrap(((ManagedEntity)entity).getEntityState().getValue(this, mappingPolicy));
        }
        return this.getValueFromEntity(entity, mappingPolicy);
    }

    @Override
    public Object getValueFromEntity(Object entity, MappingPolicy mappingPolicy) {
        try {
            Field field = this.getField();
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new MappingException("Could not access field " + this.field);
        }
    }

    @Override
    public <T> T getDefaultValue(ConversionService conversionService, Class<T> targetType) {
        if (this.defaultValue == null) {
            return (T)this.getDefaultValue(targetType);
        }
        if (targetType.isAssignableFrom(String.class)) {
            return (T)this.defaultValue;
        }
        if (conversionService == null) {
            return (T)this.getDefaultValue(targetType);
        }
        return (T)conversionService.convert((Object)this.defaultValue, targetType);
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public boolean isUnique() {
        return this.isIndexed() && this.getIndexInfo().isUnique();
    }

    private Object getDefaultValue(Class<?> type) {
        if (type != null && type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return false;
            }
            return 0;
        }
        return null;
    }

    public String toString() {
        return this.getType() + " " + this.getName() + " rel: " + this.isRelationship() + " idx: " + this.isIndexed();
    }

    @Override
    public Neo4jPersistentEntity<?> getOwner() {
        return (Neo4jPersistentEntity)super.getOwner();
    }

    public boolean isEntity() {
        return super.isEntity() && (this.isRelationshipEntity(this.getType()) || this.isNodeEntity(this.getType()));
    }

    private boolean isRelationshipEntity(Class<?> type) {
        return type.isAnnotationPresent(RelationshipEntity.class);
    }

    private boolean isNodeEntity(Class<?> type) {
        return type.isAnnotationPresent(NodeEntity.class);
    }

    @Override
    public String getIndexKey() {
        return this.getIndexInfo().getIndexKey();
    }

    @Override
    public MappingPolicy getMappingPolicy() {
        if (this.isAnnotationPresent(Fetch.class)) {
            return MappingPolicy.LOAD_POLICY;
        }
        return MappingPolicy.DEFAULT_POLICY;
    }

    @Override
    @Deprecated
    public boolean isReallyTransient() {
        return Modifier.isTransient(this.field.getModifiers()) || this.isAnnotationPresent(Transient.class) || this.isAnnotationPresent("javax.persistence.Transient");
    }

    private boolean isAnnotationPresent(String className) {
        for (Class<? extends Annotation> annotationType : this.annotations.keySet()) {
            if (!annotationType.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        Iterable result = super.getPersistentEntityType();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            TypeInformation typeInformation = (TypeInformation)it.next();
            Class type = typeInformation.getType();
            if (this.isNodeEntity(type) || this.isRelationshipEntity(type)) continue;
            if (log.isInfoEnabled()) {
                log.info("ignoring " + this.getName() + " " + type + " " + typeInformation.getActualType().getType());
            }
            it.remove();
        }
        return result;
    }

    @Override
    public MappingPolicy obtainMappingPolicy(MappingPolicy providedMappingPolicy) {
        if (providedMappingPolicy != null) {
            return providedMappingPolicy;
        }
        return this.getMappingPolicy();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!AbstractPersistentProperty.class.isInstance(other)) {
            return false;
        }
        return this.getField().equals(((AbstractPersistentProperty)other).getField());
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean hasQuery() {
        return this.query != null;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Class<?> getTargetType() {
        if (!this.isTargetTypeEnforced()) {
            return null;
        }
        if (this.isCollectionLike()) {
            return this.getComponentType();
        }
        return this.getType();
    }

    @Override
    public boolean isTargetTypeEnforced() {
        return this.getAnnotation(RelatedTo.class) != null && this.getAnnotation(RelatedTo.class).enforceTargetType();
    }
}

