/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.util.Arrays;
import java.util.Set;
import javax.validation.Validator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.neo4j.config.ConfigurationCheck;
import org.springframework.data.neo4j.config.JtaTransactionManagerFactoryBean;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryFactory;
import org.springframework.data.neo4j.fieldaccess.Neo4jConversionServiceFactoryBean;
import org.springframework.data.neo4j.fieldaccess.NodeDelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelationshipDelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.MappingInfrastructureFactoryBean;
import org.springframework.data.neo4j.support.Neo4jExceptionTranslator;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexProviderImpl;
import org.springframework.data.neo4j.support.mapping.ClassNameAlias;
import org.springframework.data.neo4j.support.mapping.EntityAlias;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.IndexCreationMappingEventListener;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityFetchHandler;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.SourceStateTransmitter;
import org.springframework.data.neo4j.support.mapping.TRSTypeAliasAccessor;
import org.springframework.data.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.data.neo4j.support.node.NodeEntityStateFactory;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityInstantiator;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityStateFactory;
import org.springframework.data.neo4j.support.typerepresentation.ClassValueTypeInformationMapper;
import org.springframework.data.neo4j.support.typerepresentation.TypeRepresentationStrategyFactory;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public abstract class Neo4jConfiguration {
    private GraphDatabaseService graphDatabaseService;
    private ConversionService conversionService;
    private Set<? extends Class<?>> initialEntitySet;
    @Autowired(required=false)
    private Validator validator;

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    @Qualifier(value="conversionService")
    @Autowired(required=false)
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Autowired(required=true)
    public void setGraphDatabaseService(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    @Bean
    @DependsOn(value={"neo4jMappingContext"})
    public MappingInfrastructureFactoryBean mappingInfrastructure() throws Exception {
        MappingInfrastructureFactoryBean factoryBean = new MappingInfrastructureFactoryBean();
        factoryBean.setGraphDatabaseService(this.getGraphDatabaseService());
        factoryBean.setTypeRepresentationStrategyFactory(this.typeRepresentationStrategyFactory());
        factoryBean.setConversionService(this.neo4jConversionService());
        factoryBean.setMappingContext(this.neo4jMappingContext());
        factoryBean.setEntityStateHandler(this.entityStateHandler());
        factoryBean.setNodeEntityStateFactory(this.nodeEntityStateFactory());
        factoryBean.setNodeTypeRepresentationStrategy(this.nodeTypeRepresentationStrategy());
        factoryBean.setNodeEntityInstantiator(this.graphEntityInstantiator());
        factoryBean.setRelationshipEntityStateFactory(this.relationshipEntityStateFactory());
        factoryBean.setRelationshipTypeRepresentationStrategy(this.relationshipTypeRepresentationStrategy());
        factoryBean.setRelationshipEntityInstantiator(this.graphRelationshipInstantiator());
        factoryBean.setTransactionManager(this.neo4jTransactionManager());
        factoryBean.setGraphDatabase(this.graphDatabase());
        factoryBean.setIsNewStrategyFactory(this.isNewStrategyFactory());
        factoryBean.setIndexProvider(this.indexProvider());
        if (this.validator != null) {
            factoryBean.setValidator(this.validator);
        }
        return factoryBean;
    }

    @Bean
    public IsNewStrategyFactory isNewStrategyFactory() throws Exception {
        return new MappingContextIsNewStrategyFactory((MappingContext)this.neo4jMappingContext());
    }

    @Bean
    public Neo4jTemplate neo4jTemplate() throws Exception {
        return new Neo4jTemplate(this.mappingInfrastructure().getObject());
    }

    @Bean
    public TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy() throws Exception {
        return this.typeRepresentationStrategyFactory().getRelationshipTypeRepresentationStrategy();
    }

    @Bean
    public TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy() throws Exception {
        return this.typeRepresentationStrategyFactory().getNodeTypeRepresentationStrategy();
    }

    @Bean
    public TypeRepresentationStrategyFactory typeRepresentationStrategyFactory() throws Exception {
        return new TypeRepresentationStrategyFactory(this.graphDatabase(), this.indexProvider());
    }

    @Bean
    public EntityStateHandler entityStateHandler() throws Exception {
        return new EntityStateHandler(this.neo4jMappingContext(), this.graphDatabase());
    }

    @Bean
    public TypeMapper<Node> nodeTypeMapper() throws Exception {
        return new DefaultTypeMapper(new TRSTypeAliasAccessor<Node>(this.nodeTypeRepresentationStrategy()), Arrays.asList(new ClassValueTypeInformationMapper()));
    }

    @Bean
    public TypeMapper<Relationship> relationshipTypeMapper() throws Exception {
        return new DefaultTypeMapper(new TRSTypeAliasAccessor<Relationship>(this.relationshipTypeRepresentationStrategy()), Arrays.asList(new ClassValueTypeInformationMapper()));
    }

    @Bean
    public Neo4jEntityFetchHandler entityFetchHandler() throws Exception {
        SourceStateTransmitter<Node> nodeSourceStateTransmitter = this.nodeStateTransmitter();
        SourceStateTransmitter<Relationship> relationshipSourceStateTransmitter = new SourceStateTransmitter<Relationship>(this.relationshipEntityStateFactory());
        return new Neo4jEntityFetchHandler(this.entityStateHandler(), this.neo4jConversionService(), nodeSourceStateTransmitter, relationshipSourceStateTransmitter);
    }

    @Bean
    public SourceStateTransmitter<Node> nodeStateTransmitter() throws Exception {
        return new SourceStateTransmitter<Node>(this.nodeEntityStateFactory());
    }

    @Bean
    protected ConversionService neo4jConversionService() throws Exception {
        Neo4jConversionServiceFactoryBean neo4jConversionServiceFactoryBean = new Neo4jConversionServiceFactoryBean();
        if (this.conversionService != null) {
            neo4jConversionServiceFactoryBean.addConverters(this.conversionService);
            return this.conversionService;
        }
        return neo4jConversionServiceFactoryBean.getObject();
    }

    @Bean
    protected RelationshipEntityInstantiator graphRelationshipInstantiator() throws Exception {
        return new RelationshipEntityInstantiator(this.entityStateHandler());
    }

    @Bean
    protected EntityInstantiator<Node> graphEntityInstantiator() throws Exception {
        return new NodeEntityInstantiator(this.entityStateHandler());
    }

    @Bean
    public Neo4jMappingContext neo4jMappingContext() throws Exception {
        Neo4jMappingContext mappingContext = new Neo4jMappingContext();
        if (this.initialEntitySet != null) {
            mappingContext.setInitialEntitySet(this.initialEntitySet);
        }
        mappingContext.setEntityAlias(this.entityAlias());
        return mappingContext;
    }

    @Bean
    protected EntityAlias entityAlias() {
        return new ClassNameAlias();
    }

    @Bean
    public RelationshipEntityStateFactory relationshipEntityStateFactory() throws Exception {
        return new RelationshipEntityStateFactory(this.neo4jMappingContext(), this.relationshipDelegatingFieldAccessorFactory());
    }

    @Bean
    public NodeEntityStateFactory nodeEntityStateFactory() throws Exception {
        return new NodeEntityStateFactory(this.neo4jMappingContext(), this.nodeDelegatingFieldAccessorFactory());
    }

    @Bean
    public FieldAccessorFactoryFactory nodeDelegatingFieldAccessorFactory() throws Exception {
        return new NodeDelegatingFieldAccessorFactory.Factory();
    }

    @Bean
    public FieldAccessorFactoryFactory relationshipDelegatingFieldAccessorFactory() throws Exception {
        return new RelationshipDelegatingFieldAccessorFactory.Factory();
    }

    @Bean(name={"neo4jTransactionManager", "transactionManager"})
    @Qualifier(value="neo4jTransactionManager")
    public PlatformTransactionManager neo4jTransactionManager() throws Exception {
        return new JtaTransactionManagerFactoryBean(this.getGraphDatabaseService()).getObject();
    }

    @Bean
    public IndexCreationMappingEventListener indexCreationMappingEventListener() throws Exception {
        return new IndexCreationMappingEventListener(this.indexProvider());
    }

    @Bean
    @Autowired
    @DependsOn(value={"graphDatabaseService"})
    public GraphDatabase graphDatabase() {
        if (this.graphDatabaseService instanceof GraphDatabase) {
            return (GraphDatabase)this.graphDatabaseService;
        }
        return new DelegatingGraphDatabase(this.graphDatabaseService);
    }

    @Bean
    public ConfigurationCheck configurationCheck() throws Exception {
        return new ConfigurationCheck(this.neo4jTemplate(), this.neo4jTransactionManager());
    }

    @Bean
    public PersistenceExceptionTranslator persistenceExceptionTranslator() {
        return new Neo4jExceptionTranslator();
    }

    @Bean
    public IndexProvider indexProvider() throws Exception {
        return new IndexProviderImpl(this.graphDatabase());
    }

    public Set<? extends Class<?>> getInitialEntitySet() {
        return this.initialEntitySet;
    }

    public void setInitialEntitySet(Set<? extends Class<?>> initialEntitySet) {
        this.initialEntitySet = initialEntitySet;
    }
}

