/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.relationship;

import org.neo4j.graphdb.Relationship;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.DetachedEntityState;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.node.EntityStateFactory;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityState;

public class RelationshipEntityStateFactory
implements EntityStateFactory<Relationship> {
    private final FieldAccessorFactoryFactory relationshipDelegatingFieldAccessorFactory;
    private final Neo4jMappingContext mappingContext;

    public RelationshipEntityStateFactory(Neo4jMappingContext mappingContext, FieldAccessorFactoryFactory relationshipDelegatingFieldAccessorFactory) {
        this.mappingContext = mappingContext;
        this.relationshipDelegatingFieldAccessorFactory = relationshipDelegatingFieldAccessorFactory;
    }

    @Override
    public EntityState<Relationship> getEntityState(Object entity, boolean detachable, Neo4jTemplate template) {
        Class<?> entityType = entity.getClass();
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        DelegatingFieldAccessorFactory fieldAccessorFactory = this.relationshipDelegatingFieldAccessorFactory.provideFactoryFor(template);
        RelationshipEntityState relationshipEntityState = new RelationshipEntityState(null, entity, entityType, template, fieldAccessorFactory, persistentEntity);
        if (!detachable) {
            return relationshipEntityState;
        }
        return new DetachedEntityState<Relationship>(relationshipEntityState, template);
    }
}

