/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.springframework.data.neo4j.fieldaccess.RelationshipHelper;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipProperties;

class RelationshipEntities {
    private final RelationshipHelper relationshipHelper;
    private final Neo4jPersistentProperty property;
    private final RelationshipProperties relationshipProperties;
    private final Neo4jPersistentProperty endNodeProperty;
    private final Neo4jPersistentProperty startNodeProperty;
    private final MappingPolicy endNodeMappingPolicy;
    private final MappingPolicy startNodeMappingPolicy;

    public RelationshipEntities(RelationshipHelper relationshipHelper, Neo4jPersistentProperty property) {
        this.relationshipHelper = relationshipHelper;
        this.property = property;
        this.relationshipProperties = property.getRelationshipInfo().getTargetEntity().getRelationshipProperties();
        this.endNodeProperty = this.relationshipProperties.getEndNodeProperty();
        this.startNodeProperty = this.relationshipProperties.getStartNodeProperty();
        this.endNodeMappingPolicy = this.endNodeProperty.getMappingPolicy();
        this.startNodeMappingPolicy = this.startNodeProperty.getMappingPolicy();
    }

    public Node getOtherNode(Node startNode, Object relationshipEntity) {
        Object fieldValue = this.endNodeProperty.getValue(relationshipEntity, this.endNodeMappingPolicy);
        if (fieldValue == null) {
            throw new IllegalArgumentException("End node must not be null (" + relationshipEntity.getClass().getName() + ")");
        }
        Node endNode = this.relationshipHelper.getNode(fieldValue);
        if (startNode.equals(endNode)) {
            return this.relationshipHelper.getNode(this.startNodeProperty.getValue(relationshipEntity, this.startNodeMappingPolicy));
        }
        return endNode;
    }

    public Map<Node, Object> loadEndNodeToRelationshipEntityMapping(Node startNode, Iterable<Object> values, Class<?> relatedType) {
        HashMap<Node, Object> endNodeToEntityMapping = new HashMap<Node, Object>();
        for (Object entry : values) {
            if (!relatedType.isInstance(entry)) {
                throw new IllegalArgumentException("Elements of " + this.property + " collection must be of " + relatedType);
            }
            Node endNode = this.getOtherNode(startNode, entry);
            endNodeToEntityMapping.put(endNode, entry);
        }
        return endNodeToEntityMapping;
    }
}

