/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class IdFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public IdFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return property.isIdProperty();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        return new IdFieldAccessor(property, this.template);
    }

    public static class IdFieldAccessor
    implements FieldAccessor {
        protected final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;

        public IdFieldAccessor(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
        }

        @Override
        public boolean isWriteable(Object entity) {
            return false;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            return newVal;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            Object state = this.template.getPersistentState(entity);
            if (state instanceof Node) {
                return DoReturn.doReturn(((Node)state).getId());
            }
            if (state instanceof Relationship) {
                return DoReturn.doReturn(((Relationship)state).getId());
            }
            throw new MappingException("Error retrieving id value from " + entity);
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

