/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.IndexInfo;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

public class PartInfo {
    private final PersistentPropertyPath<Neo4jPersistentProperty> path;
    private final String variable;
    private final Part part;
    private final int index;

    public PartInfo(PersistentPropertyPath<Neo4jPersistentProperty> path, String variable, Part part, int index) {
        Assert.notNull(path);
        Assert.hasText((String)variable);
        this.path = path;
        this.variable = variable;
        this.part = part;
        this.index = index;
    }

    protected Part.Type getType() {
        return this.part.getType();
    }

    Neo4jPersistentProperty getLeafProperty() {
        return (Neo4jPersistentProperty)this.path.getLeafProperty();
    }

    public boolean isPrimitiveProperty() {
        return !this.isRelationship();
    }

    private boolean isRelationship() {
        return this.getLeafProperty().isRelationship();
    }

    public boolean isIndexed() {
        return this.getLeafProperty().isIndexed();
    }

    public String getVariable() {
        return this.variable;
    }

    public int getParameterIndex() {
        return this.index;
    }

    public String getIndexName() {
        return this.getIndexInfo().getIndexName();
    }

    public boolean isFullText() {
        return this.isIndexed() && this.getIndexInfo().isFullText();
    }

    private IndexInfo getIndexInfo() {
        return this.getLeafProperty().getIndexInfo();
    }

    String getNeo4jPropertyName() {
        Neo4jPersistentProperty leafProperty = this.getLeafProperty();
        return leafProperty.getNeo4jPropertyName();
    }

    public String getIndexKey() {
        return this.getIndexInfo().getIndexKey();
    }
}

