/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.IdFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.util.TypeInformation;

public class FieldAccessorFactoryProviders<T> {
    private final TypeInformation<?> type;
    private final List<FieldAccessorFactoryProvider<T>> fieldAccessorFactoryProviders = new ArrayList<FieldAccessorFactoryProvider<T>>();
    private final IdFieldAccessorFactory idFieldAccessorFactory;
    private Neo4jPersistentProperty idProperty;

    FieldAccessorFactoryProviders(TypeInformation<?> type, Neo4jTemplate template) {
        this.type = type;
        this.idFieldAccessorFactory = new IdFieldAccessorFactory(template);
    }

    public Map<Neo4jPersistentProperty, FieldAccessor> getFieldAccessors() {
        HashMap<Neo4jPersistentProperty, FieldAccessor> result = new HashMap<Neo4jPersistentProperty, FieldAccessor>(this.fieldAccessorFactoryProviders.size(), 1.0f);
        for (FieldAccessorFactoryProvider<T> fieldAccessorFactoryProvider : this.fieldAccessorFactoryProviders) {
            FieldAccessor accessor = fieldAccessorFactoryProvider.accessor();
            result.put(fieldAccessorFactoryProvider.getProperty(), accessor);
        }
        return result;
    }

    public Map<Neo4jPersistentProperty, List<FieldAccessListener>> getFieldAccessListeners() {
        HashMap<Neo4jPersistentProperty, List<FieldAccessListener>> result = new HashMap<Neo4jPersistentProperty, List<FieldAccessListener>>(this.fieldAccessorFactoryProviders.size(), 1.0f);
        for (FieldAccessorFactoryProvider<T> fieldAccessorFactoryProvider : this.fieldAccessorFactoryProviders) {
            List<FieldAccessListener> listeners = fieldAccessorFactoryProvider.listeners();
            result.put(fieldAccessorFactoryProvider.getProperty(), listeners);
        }
        return result;
    }

    public void add(Neo4jPersistentProperty property, FieldAccessorFactory fieldAccessorFactory, List<FieldAccessorListenerFactory> listenerFactories) {
        this.fieldAccessorFactoryProviders.add(new FieldAccessorFactoryProvider(property, fieldAccessorFactory, listenerFactories));
        if (property.isIdProperty()) {
            this.idProperty = property;
        }
    }

    public Neo4jPersistentProperty getIdProperty() {
        return this.idProperty;
    }

    static class FieldAccessorFactoryProvider<E> {
        private final Neo4jPersistentProperty property;
        private final FieldAccessorFactory fieldAccessorFactory;
        private final List<FieldAccessorListenerFactory> fieldAccessorListenerFactories;

        FieldAccessorFactoryProvider(Neo4jPersistentProperty property, FieldAccessorFactory fieldAccessorFactory, List fieldAccessorListenerFactories) {
            this.property = property;
            this.fieldAccessorFactory = fieldAccessorFactory;
            this.fieldAccessorListenerFactories = fieldAccessorListenerFactories;
        }

        public FieldAccessor accessor() {
            if (this.fieldAccessorFactory == null) {
                return null;
            }
            return this.fieldAccessorFactory.forField(this.property);
        }

        public List<FieldAccessListener> listeners() {
            if (this.fieldAccessorListenerFactories == null) {
                return null;
            }
            ArrayList<FieldAccessListener> listeners = new ArrayList<FieldAccessListener>(this.fieldAccessorListenerFactories.size());
            for (FieldAccessorListenerFactory fieldAccessorListenerFactory : this.fieldAccessorListenerFactories) {
                listeners.add(fieldAccessorListenerFactory.forField(this.property));
            }
            return listeners;
        }

        public Neo4jPersistentProperty getProperty() {
            return this.property;
        }
    }
}

