/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.Transaction;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.core.UncategorizedGraphStoreException;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.util.ObjectUtils;

public class DetachedEntityState<STATE>
implements EntityState<STATE> {
    private final Map<Neo4jPersistentProperty, ExistingValue> dirty = new HashMap<Neo4jPersistentProperty, ExistingValue>();
    protected final EntityState<STATE> delegate;
    private static final Log log = LogFactory.getLog(DetachedEntityState.class);
    private Neo4jTemplate template;
    private Neo4jPersistentEntity<?> persistentEntity;

    public DetachedEntityState(EntityState<STATE> delegate, Neo4jTemplate template) {
        this.delegate = delegate;
        this.persistentEntity = delegate.getPersistentEntity();
        this.template = template;
    }

    @Override
    public boolean isWritable(Neo4jPersistentProperty property) {
        return this.delegate.isWritable(property);
    }

    @Override
    public Object getEntity() {
        return this.delegate.getEntity();
    }

    @Override
    public boolean hasPersistentState() {
        return this.delegate.hasPersistentState();
    }

    @Override
    public STATE getPersistentState() {
        return this.delegate.getPersistentState();
    }

    @Override
    public Neo4jPersistentEntity<?> getPersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public Object getValue(Neo4jPersistentProperty property, MappingPolicy mappingPolicy) {
        MappingPolicy mappingPolicy2 = mappingPolicy = mappingPolicy == null ? property.getMappingPolicy() : mappingPolicy;
        if (this.isDetached() && (this.template.getPersistentState(this.getEntity()) == null || this.isDirty(property))) {
            Object entityValue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Outside of transaction, GET value from field " + property));
            }
            if ((entityValue = this.getValueFromEntity(property, MappingPolicy.MAP_FIELD_DIRECT_POLICY)) != null) {
                return entityValue;
            }
            Object defaultValue = this.getDefaultValue(property);
            if (defaultValue != null) {
                Object entity = this.getEntity();
                property.setValue(entity, defaultValue);
                this.addDirty(property, defaultValue, false);
            }
            return defaultValue;
        }
        return this.delegate.getValue(property, mappingPolicy);
    }

    @Override
    public Object getValue(Field field, MappingPolicy mappingPolicy) {
        return this.getValue(this.property(field), mappingPolicy);
    }

    protected boolean isDetached() {
        return !this.transactionIsRunning() || !this.hasPersistentState() || this.isDirty();
    }

    protected boolean transactionIsRunning() {
        return this.getTemplate().transactionIsRunning();
    }

    @Override
    public Object setValue(Field field, Object newVal, MappingPolicy mappingPolicy) {
        return this.setValue(this.property(field), newVal, mappingPolicy);
    }

    private Neo4jPersistentProperty property(Field field) {
        return (Neo4jPersistentProperty)this.persistentEntity.getPersistentProperty(field.getName());
    }

    @Override
    public Object setValue(Neo4jPersistentProperty property, Object newVal, MappingPolicy mappingPolicy) {
        if (this.isDetached()) {
            if (!this.isDirty(property) && this.isWritable(property)) {
                if (this.hasPersistentState()) {
                    this.addDirty(property, DoReturn.unwrap(this.delegate.getValue(property, MappingPolicy.MAP_FIELD_DIRECT_POLICY)), true);
                } else {
                    this.addDirty(property, newVal, false);
                }
            }
            return newVal;
        }
        return this.delegate.setValue(property, newVal, mappingPolicy);
    }

    @Override
    public Object getDefaultValue(Neo4jPersistentProperty property) {
        return this.delegate.getDefaultValue(property);
    }

    private Object getDefaultValue(Class<?> type) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return false;
            }
            return 0;
        }
        return null;
    }

    @Override
    public void createAndAssignState() {
        if (this.template.transactionIsRunning()) {
            this.delegate.createAndAssignState();
        } else {
            log.warn((Object)("New Nodebacked created outside of transaction " + this.delegate.getEntity().getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDirty() {
        Object entity = this.getEntity();
        if (!this.hasPersistentState()) {
            throw new IllegalStateException("Flushing detached entity without a persistent state, this had to be created first.");
        }
        if (this.isDirty()) {
            HashMap<Neo4jPersistentProperty, ExistingValue> dirtyCopy = new HashMap<Neo4jPersistentProperty, ExistingValue>(this.dirty);
            try {
                for (Map.Entry<Neo4jPersistentProperty, ExistingValue> entry : dirtyCopy.entrySet()) {
                    Neo4jPersistentProperty property = (Neo4jPersistentProperty)entry.getKey();
                    Object valueFromEntity = this.getValueFromEntity(property, MappingPolicy.MAP_FIELD_DIRECT_POLICY);
                    this.cascadePersist(valueFromEntity);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Flushing dirty Entity new node " + entity + " field " + property + " with value " + valueFromEntity));
                    }
                    MappingPolicy mappingPolicy = property.getMappingPolicy();
                    this.checkConcurrentModification(entity, entry, property, mappingPolicy);
                    this.delegate.setValue(property, valueFromEntity, mappingPolicy);
                    this.dirty.remove(property);
                }
            }
            finally {
                if (!this.dirty.isEmpty()) {
                    this.dirty.putAll(dirtyCopy);
                }
            }
        }
    }

    private void cascadePersist(Object valueFromEntity) {
    }

    @Override
    public void setPersistentState(STATE state) {
        this.delegate.setPersistentState(state);
    }

    private Object getValueFromEntity(Neo4jPersistentProperty property, MappingPolicy mappingPolicy) {
        Object entity = this.getEntity();
        return property.getValue(entity, mappingPolicy);
    }

    private void checkConcurrentModification(Object entity, Map.Entry<Neo4jPersistentProperty, ExistingValue> entry, Neo4jPersistentProperty property, MappingPolicy mappingPolicy) {
        Object nodeValue;
        ExistingValue previousValue = entry.getValue();
        if (previousValue.mustCheckConcurrentModification() && !ObjectUtils.nullSafeEquals((Object)(nodeValue = DoReturn.unwrap(this.delegate.getValue(property, mappingPolicy))), (Object)previousValue.value)) {
            throw new ConcurrentModificationException("Node " + entity + " field " + property + " changed in between previous " + previousValue + " current " + nodeValue);
        }
    }

    private boolean isDirty() {
        return !this.dirty.isEmpty();
    }

    private boolean isDirty(Neo4jPersistentProperty property) {
        return this.dirty.containsKey(property);
    }

    private void clearDirty() {
        this.dirty.clear();
    }

    private void clearDirty(Field f) {
        this.dirty.remove(f);
    }

    private void addDirty(Neo4jPersistentProperty property, Object previousValue, boolean fromGraph) {
        this.dirty.put(property, new ExistingValue(previousValue, fromGraph));
    }

    public Neo4jTemplate getTemplate() {
        return this.template;
    }

    @Override
    public Object persist() {
        if (!this.isDetached()) {
            return this.getEntity();
        }
        Transaction tx = this.template.beginTx();
        try {
            Object result = this.delegate.persist();
            this.flushDirty();
            tx.success();
            Object object = result;
            return object;
        }
        catch (Throwable t) {
            tx.failure();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UncategorizedGraphStoreException("Error persisting " + this.getEntity(), t);
        }
        finally {
            tx.finish();
        }
    }

    static class ExistingValue {
        public final Object value;
        private final boolean fromGraph;

        ExistingValue(Object value, boolean fromGraph) {
            this.value = value;
            this.fromGraph = fromGraph;
        }

        public String toString() {
            return String.format("ExistingValue{value=%s, fromGraph=%s}", this.value, this.fromGraph);
        }

        private boolean mustCheckConcurrentModification() {
            return this.fromGraph;
        }
    }
}

