/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.mapping.InvalidEntityTypeException;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentPropertyImpl;
import org.springframework.data.util.TypeInformation;

public class Neo4jMappingContext
extends AbstractMappingContext<Neo4jPersistentEntityImpl<?>, Neo4jPersistentProperty> {
    protected <T> Neo4jPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        Class type = typeInformation.getType();
        if (type.isAnnotationPresent(NodeEntity.class)) {
            return new Neo4jPersistentEntityImpl<T>(typeInformation);
        }
        if (type.isAnnotationPresent(RelationshipEntity.class)) {
            return new Neo4jPersistentEntityImpl<T>(typeInformation);
        }
        throw new InvalidEntityTypeException("Type " + type + " is neither a @NodeEntity nor a @RelationshipEntity");
    }

    protected Neo4jPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, Neo4jPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new Neo4jPersistentPropertyImpl(field, descriptor, owner, simpleTypeHolder, this);
    }

    public boolean isNodeEntity(Class<?> type) {
        try {
            return ((Neo4jPersistentEntityImpl)this.getPersistentEntity(type)).isNodeEntity();
        }
        catch (InvalidEntityTypeException me) {
            return false;
        }
    }

    public boolean isRelationshipEntity(Class<?> type) {
        try {
            return ((Neo4jPersistentEntityImpl)this.getPersistentEntity(type)).isRelationshipEntity();
        }
        catch (InvalidEntityTypeException me) {
            return false;
        }
    }

    public void setPersistentState(Object entity, PropertyContainer pc) {
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.getPersistentEntity(entity.getClass());
        persistentEntity.setPersistentState(entity, pc);
    }
}

