/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.index;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.ParameterCheck;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;

public class IndexProviderImpl
implements IndexProvider {
    private final Neo4jMappingContext mappingContext;
    private final GraphDatabase graphDatabase;

    public IndexProviderImpl(Neo4jMappingContext mappingContext, GraphDatabase graphDatabase) {
        this.mappingContext = mappingContext;
        this.graphDatabase = graphDatabase;
    }

    @Override
    public <S extends PropertyContainer, T> Index<S> getIndex(Class<T> type) {
        return this.getIndex(type, null);
    }

    @Override
    public <S extends PropertyContainer, T> Index<S> getIndex(Class<T> type, String indexName) {
        return this.getIndex(type, indexName, null);
    }

    @Override
    public <S extends PropertyContainer, T> Index<S> getIndex(Class<T> type, String indexName, IndexType indexType) {
        boolean useExistingIndex;
        if (type == null) {
            ParameterCheck.notNull((Object)indexName, "indexName");
            return this.getIndex(indexName);
        }
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(type);
        if (indexName == null) {
            indexName = this.customizeIndexName(Indexed.Name.get(type), type);
        }
        boolean bl = useExistingIndex = indexType == null;
        if (useExistingIndex) {
            if (persistentEntity.isNodeEntity() || persistentEntity.isRelationshipEntity()) {
                return this.graphDatabase.getIndex(indexName);
            }
            throw new IllegalArgumentException("Wrong index type supplied: " + type + " expected Node- or Relationship-Entity");
        }
        if (persistentEntity.isNodeEntity()) {
            return this.createIndex(Node.class, indexName, indexType);
        }
        if (persistentEntity.isRelationshipEntity()) {
            return this.createIndex(Relationship.class, indexName, indexType);
        }
        throw new IllegalArgumentException("Wrong index type supplied: " + type + " expected Node- or Relationship-Entity");
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        return this.graphDatabase.getIndex(indexName);
    }

    @Override
    public boolean isNode(Class<? extends PropertyContainer> type) {
        if (type.equals(Node.class)) {
            return true;
        }
        if (type.equals(Relationship.class)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown Graph Primitive, neither Node nor Relationship" + type);
    }

    @Override
    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, IndexType fullText) {
        return this.graphDatabase.createIndex(type, indexName, fullText);
    }

    @Override
    public <S extends PropertyContainer> Index<S> getIndex(Neo4jPersistentProperty property, Class<?> instanceType) {
        Indexed indexedAnnotation = property.getAnnotation(Indexed.class);
        Class declaringType = property.getOwner().getType();
        String providedIndexName = indexedAnnotation == null || indexedAnnotation.indexName().isEmpty() ? null : indexedAnnotation.indexName();
        Indexed.Level level = indexedAnnotation == null ? Indexed.Level.CLASS : indexedAnnotation.level();
        String indexName = this.customizeIndexName(Indexed.Name.get(level, declaringType, providedIndexName, instanceType), instanceType);
        if (!property.isIndexed() || property.getIndexInfo().getIndexType() == IndexType.SIMPLE) {
            return this.getIndex(declaringType, indexName, IndexType.SIMPLE);
        }
        String defaultIndexName = this.customizeIndexName(Indexed.Name.get(level, declaringType, null, instanceType.getClass()), instanceType);
        if (providedIndexName == null || providedIndexName.equals(defaultIndexName)) {
            throw new IllegalStateException("Index name for " + property + " must differ from the default name: " + defaultIndexName);
        }
        return this.getIndex(declaringType, indexName, property.getIndexInfo().getIndexType());
    }

    @Override
    public String createIndexValueForType(Class<?> type) {
        return type.getName();
    }

    @Override
    public String customizeIndexName(String indexName, Class<?> type) {
        return indexName;
    }
}

