/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.NodeRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.NodeToNodesRelationshipFieldAccessor;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class OneToNRelationshipFieldAccessorFactory
extends NodeRelationshipFieldAccessorFactory {
    public OneToNRelationshipFieldAccessorFactory(Neo4jTemplate template) {
        super(template);
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        if (!property.isRelationship()) {
            return false;
        }
        RelationshipInfo info = property.getRelationshipInfo();
        return info.isMultiple() && info.targetsNodes() && !info.isReadonly();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        Class targetType = relationshipInfo.getTargetType().getType();
        return new OneToNRelationshipFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), targetType, this.template, property);
    }

    public static class OneToNRelationshipFieldAccessor
    extends NodeToNodesRelationshipFieldAccessor {
        public OneToNRelationshipFieldAccessor(RelationshipType type, Direction direction, Class<?> elementClass, Neo4jTemplate template, Neo4jPersistentProperty property) {
            super(elementClass, template, direction, type, property);
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Node node = (Node)this.checkUnderlyingState(entity);
            if (newVal == null) {
                return null;
            }
            Set<Node> targetNodes = this.createSetOfTargetNodes(newVal);
            this.removeMissingRelationships(node, targetNodes);
            this.createAddedRelationships(node, targetNodes);
            return this.createManagedSet(entity, (Set)newVal, this.updateMappingPolicy(mappingPolicy));
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            this.checkUnderlyingState(entity);
            MappingPolicy currentPolicy = this.updateMappingPolicy(mappingPolicy);
            Set<Object> result = this.createEntitySetFromRelationshipEndNodes(entity, currentPolicy);
            return DoReturn.doReturn(this.createManagedSet(entity, result, currentPolicy));
        }

        @Override
        public Object getDefaultValue() {
            return new HashSet();
        }
    }
}

