/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.fieldaccess.AbstractNodeRelationshipFieldAccessor;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public abstract class NodeToNodesRelationshipFieldAccessor
extends AbstractNodeRelationshipFieldAccessor<Node, Node> {
    public NodeToNodesRelationshipFieldAccessor(Class<?> clazz, Neo4jTemplate template, Direction direction, RelationshipType type, Neo4jPersistentProperty property) {
        super(clazz, template, direction, type, property);
    }

    @Override
    protected Relationship obtainSingleRelationship(Node start, Node end) {
        Iterable existingRelationships = start.getRelationships(this.type, this.direction);
        for (Relationship existingRelationship : existingRelationships) {
            if (existingRelationship == null || !existingRelationship.getOtherNode(start).equals(end)) continue;
            return existingRelationship;
        }
        return start.createRelationshipTo(end, this.type);
    }

    @Override
    protected Iterable<Node> getStatesFromEntity(Object entity) {
        Node entityNode = this.getState(entity);
        HashSet<Node> result = new HashSet<Node>();
        for (Relationship rel : entityNode.getRelationships(this.type, this.direction)) {
            result.add(rel.getOtherNode(entityNode));
        }
        return result;
    }

    @Override
    protected Node getState(Object entity) {
        return (Node)this.template.getPersistentState(entity);
    }
}

