/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.index.impl.lucene.QueryNotPossibleException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.StoreFailureException;
import org.neo4j.kernel.impl.persistence.IdGenerationFailedException;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockException;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.UncategorizedGraphStoreException;

public class Neo4jExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        try {
            throw ex;
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidDataAccessApiUsageException(iae.getMessage(), (Throwable)iae);
        }
        catch (DataAccessException dae) {
            throw dae;
        }
        catch (NotInTransactionException nit) {
            throw new InvalidDataAccessApiUsageException(nit.getMessage(), (Throwable)nit);
        }
        catch (TransactionFailureException tfe) {
            throw new UncategorizedGraphStoreException(tfe.getMessage(), tfe);
        }
        catch (ReadOnlyDbException rodbe) {
            throw new InvalidDataAccessResourceUsageException(rodbe.getMessage(), (Throwable)rodbe);
        }
        catch (IllegalResourceException ire) {
            throw new InvalidDataAccessResourceUsageException(ire.getMessage(), (Throwable)ire);
        }
        catch (StoreFailureException sfe) {
            throw new DataAccessResourceFailureException(sfe.getMessage(), (Throwable)sfe);
        }
        catch (IdGenerationFailedException idfe) {
            throw new NonTransientDataAccessResourceException(idfe.getMessage(), (Throwable)idfe);
        }
        catch (NotFoundException nfe) {
            throw new DataRetrievalFailureException(nfe.getMessage(), (Throwable)nfe);
        }
        catch (QueryNotPossibleException qnpe) {
            throw new ConcurrencyFailureException(qnpe.getMessage(), (Throwable)qnpe);
        }
        catch (DeadlockDetectedException dde) {
            throw new ConcurrencyFailureException(dde.getMessage(), (Throwable)dde);
        }
        catch (LockException le) {
            throw new ConcurrencyFailureException(le.getMessage(), (Throwable)le);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }
}

